% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_ymwdh_tbl.R
\name{ts_ymwdh_tbl}
\alias{ts_ymwdh_tbl}
\title{Make a tibble with year, month, week, week day and hour information added}
\usage{
ts_ymwdh_tbl(.data, .date_col)
}
\arguments{
\item{.data}{The data that is being analyzed, data must be a tibble/data.frame}

\item{.date_col}{The column of the tibble that holds the date}
}
\value{
A tibble
}
\description{
Returns a tibble that has year, month, week, week day and hour added from a date column
}
\details{
\itemize{
\item Supply data with a date column and this will add the year, month, week, week day and hour
to the tibble. The original date column is kept.
\item Returns a tibble.
\item You must know the data going into the function and if certain columns
should be dropped or kept when using further functions
\item Future work - Add boolean for pad_by_time to fill in missing time series information
}
}
\examples{
library(timetk)

ts_ymwdh_tbl(
  .data = m4_daily
  , .date_col = date
)

}
