% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_median_excess_plt.R
\name{ts_median_excess_plt}
\alias{ts_median_excess_plt}
\title{Create a plot showing the excess of the median value}
\usage{
ts_median_excess_plt(
  .data,
  .date_col,
  .value_col,
  .x_axis,
  .ggplot_group_var,
  .years_back
)
}
\arguments{
\item{.data}{The data that is being analyzed, data must be a tibble/data.frame}

\item{.date_col}{The column of the tibble that holds the date}

\item{.value_col}{The column that holds the value of interest}

\item{.x_axis}{What is the be the x-axis, day, week, etc.}

\item{.ggplot_group_var}{The variable to group the ggplot on}

\item{.years_back}{How many yeas back do you want to go in order to compute
the median value}
}
\value{
A \code{ggplot2} plot
}
\description{
Plot out the excess +/- of the median value grouped by certain time parameters
}
\details{
\itemize{
\item Supply data that you want to view and you will see the excess +/- of the median values
over a specified time series tibble
}
}
\examples{

suppressPackageStartupMessages(library(timetk))

ts_ymwdh_tbl(
  .data = m4_daily
  , .date_col = date
) \%>\%
ts_median_excess_plt(
  .date_col = date
  , .value_col = value
  , .x_axis = wk
  , .ggplot_group_var = yr
  , .years_back = 5
)

}
