% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-auto-stationarize.R
\name{auto_stationarize}
\alias{auto_stationarize}
\title{Automatically Stationarize Time Series Data}
\usage{
auto_stationarize(.time_series)
}
\arguments{
\item{.time_series}{A time series object to be made stationary.}
}
\value{
If the time series is already stationary, it returns the original time series.
If a transformation is applied to make it stationary, it returns a list with two elements:
\itemize{
\item stationary_ts: The stationary time series.
\item ndiffs: The order of differencing applied to make it stationary.
}
}
\description{
This function attempts to make a non-stationary time series stationary.
This function attempts to make a given time series stationary by applying transformations
such as differencing or logarithmic transformation. If the time series is already
stationary, it returns the original time series.
}
\details{
If the input time series is non-stationary (determined by the Augmented Dickey-Fuller test),
this function will try to make it stationary by applying a series of transformations:
\enumerate{
\item It checks if the time series is already stationary using the Augmented Dickey-Fuller test.
\item If not stationary, it attempts a logarithmic transformation.
\item If the logarithmic transformation doesn't work, it applies differencing.
}
}
\examples{
# Example 1: Using the AirPassengers dataset
auto_stationarize(AirPassengers)

# Example 2: Using the BJsales dataset
auto_stationarize(BJsales)

}
\seealso{
Other Utility: 
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
