% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-arima-boost.R
\name{ts_wfs_arima_boost}
\alias{ts_wfs_arima_boost}
\title{Auto Arima XGBoost Workflowset Function}
\usage{
ts_wfs_arima_boost(
  .model_type = "all_engines",
  .recipe_list,
  .trees = 10,
  .min_node = 2,
  .tree_depth = 6,
  .learn_rate = 0.015,
  .stop_iter = NULL,
  .seasonal_period = 0,
  .non_seasonal_ar = 0,
  .non_seasonal_differences = 0,
  .non_seasonal_ma = 0,
  .seasonal_ar = 0,
  .seasonal_differences = 0,
  .seasonal_ma = 0
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[modeltime:arima_boost]{modeltime::arima_boost()}} under the hood and can take one of the following:
\itemize{
\item "arima_xgboost"
\item "auto_arima_xgboost
\item "all_engines" - This will make a model spec for all available engines.
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.trees}{An integer for the number of trees contained in the ensemble.}

\item{.min_node}{An integer for the minimum number of data points in a node
that is required for the node to be split further.}

\item{.tree_depth}{An integer for the maximum depth of the tree
(i.e. number of splits) (specific engines only).}

\item{.learn_rate}{A number for the rate at which the boosting algorithm
adapts from iteration-to-iteration (specific engines only).}

\item{.stop_iter}{The number of iterations without improvement before
stopping (xgboost only).}

\item{.seasonal_period}{Set to 0,}

\item{.non_seasonal_ar}{Set to 0,}

\item{.non_seasonal_differences}{Set to 0,}

\item{.non_seasonal_ma}{Set to 0,}

\item{.seasonal_ar}{Set to 0,}

\item{.seasonal_differences}{Set to 0,}

\item{.seasonal_ma}{Set to 0,}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This uses the option \code{set_engine("auto_arima_xgboost")} or \code{set_engine("arima_xgboost")}

\code{\link[modeltime:arima_boost]{modeltime::arima_boost()}} arima_boost() is a way to generate a specification
of a time series model that uses boosting to improve modeling errors
(residuals) on Exogenous Regressors. It works with both "automated" ARIMA
(auto.arima) and standard ARIMA (arima). The main algorithms are:
\itemize{
\item Auto ARIMA + XGBoost Errors (engine = auto_arima_xgboost, default)
\item ARIMA + XGBoost Errors (engine = arima_xgboost)
}
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(tidymodels))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_arima_boost("all_engines", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://business-science.github.io/modeltime/reference/arima_boost.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
