% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{OrderedSample}
\alias{OrderedSample}
\title{World Health Organization (WHO)}
\format{
\subsection{\code{OrderedSample}}{

A data frame with 5 rows and 11 columns.
\describe{
\item{indicator}{indicator name}
\item{dimension}{dimension of inequality}
\item{subgroup}{population subgroup within a given dimension of inequality}
\item{subgroup_order}{the order of subgroups in an increasing sequence}
\item{estimate}{subgroup estimate}
\item{se}{standard error of the subgroup estimate}
\item{population}{number of people within each subgroup}
\item{setting_average}{indicator average for the setting}
\item{favourable_indicator}{favourable (1) or non-favourable (0) indicator}
\item{ordered_dimension}{ordered (1) or non-ordered (0) dimension}
\item{indicator_scale}{scale of the indicator}
}
}
}
\source{
WHO Health Inequality Data Repository\url{https://www.who.int/data/inequality-monitor/data}
}
\usage{
OrderedSample
}
\description{
This dataset contains sample data for computing ordered summary measures of
health inequality. It contains data from a household survey for the
proportion of births attended by skilled health personnel disaggregated by
economic status, measured by wealth quintiles.
}
\details{
The proportion of births attended by skilled health personnel is calculated
as the number of births attended by skilled health personnel divided by the
total number of live births to women aged 15-49 years occurring in the
period prior to the survey.

Skilled health personnel include doctors, nurses, midwives and other
medically trained personnel, as defined according to each country. This is
in line with the definition used by the Countdown to 2030 Collaboration,
Demographic and Health Surveys (DHS), Multiple Indicator Cluster Surveys
(MICS) and Reproductive Health Surveys (RHS).

Economic status is determined using a wealth index, which is based on owning
selected assets and having access to certain services. The wealth index is
divided into five equal subgroups (quintiles) that each account for 20\% of
the population. Economic status is an ordered dimension (meaning that the
subgroups have an inherent ordering).

This dataset can be used to calculate ordered summary measures of health
inequality, including: absolute concentration index (ACI), relative
concentration index (RCI), slope index of inequality (SII) and relative
index of inequality (RII). It can also be used to calculate the impact
measures population attributable risk (PAR) and population attributable
fraction (PAF).
}
\examples{
head(OrderedSample)
summary(OrderedSample)
}
\keyword{datasets}
