/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5FDhdfs_H
#define H5FDhdfs_H

#include "H5FDpublic.h" 

#ifdef H5_HAVE_LIBHDFS

#define H5FD_HDFS (H5OPEN H5FD_HDFS_id_g)

#define H5FD_HDFS_VALUE H5_VFD_HDFS

#else

#define H5FD_HDFS       (H5I_INVALID_HID)

#define H5FD_HDFS_VALUE H5_VFD_INVALID

#endif 

#ifdef H5_HAVE_LIBHDFS

#define H5FD__CURR_HDFS_FAPL_T_VERSION 1

#define H5FD__HDFS_NODE_NAME_SPACE 128

#define H5FD__HDFS_USER_NAME_SPACE 128

#define H5FD__HDFS_KERB_CACHE_PATH_SPACE 128

typedef struct H5FD_hdfs_fapl_t {
    int32_t version;
    char    namenode_name[H5FD__HDFS_NODE_NAME_SPACE + 1];
    int32_t namenode_port;
    char    user_name[H5FD__HDFS_USER_NAME_SPACE + 1];
    char    kerberos_ticket_cache[H5FD__HDFS_KERB_CACHE_PATH_SPACE + 1];
    int32_t stream_buffer_size;
} H5FD_hdfs_fapl_t;

#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5FD_HDFS_id_g;

H5_DLL herr_t H5Pset_fapl_hdfs(hid_t fapl_id, H5FD_hdfs_fapl_t *fa);

H5_DLL herr_t H5Pget_fapl_hdfs(hid_t fapl_id, H5FD_hdfs_fapl_t *fa_out);

#ifdef __cplusplus
}
#endif
#endif 

#endif 
