# ---------------------------------------------------------------------
# METHOD: set.R
#   Sets a key-value pair for the hash object
# 
#  TODO:
#   - To be more consistent with R we might want to switch this to
#     set( keys, values, h ).  This may not be necessary since
#     we have already vectorized the setting here.
#   - It may be faster to set the key-value pairs with a for-loop 
#     instead of apply.
#
# ---------------------------------------------------------------------


setGeneric( 
	"set" , 
	function( h, x, ...) standardGeneric( "set" )
)

# SIGNATURE: "hash", "vector"
setMethod( 
	"set" ,
  signature( h = "hash", x = "vector") , 
	function( h, x, value) {
	  	
  	  # Warnings... 
		key <- validate.key(x)

      # Equal keys and values 
		if ( length(key) == length(value) ) {
		 	mapply( assign, key, value, MoreArgs = list( envir = h@x ) )
  		}
		

  	  # One key set the vector of values
		if ( length(key) == 1 ) assign( key, value, envir=h@x )


      # Many keys with the same value
		if ( length(value) == 1 ) {
		  # for ( i in 1:length(key) ) assign( key[i], value, envir=h@x )
			sapply( key, assign, value, h@x )
		}

	  # UNEQUAL keys and values both greater than one 	
		if ( length(key) > 1 & length(value) > 1 & length(key) != length(value) ) {
			stop( 
				"\nCannot set values of length ", length( value ), 
 				" to keys of length ", length( key )
			)
		}

  	    return( invisible(0) )

	}

	
) # END METHOD SET





# SIGNATURE: data.frame
setMethod( 
	"set" ,
	signature( "hash", "data.frame" ) ,
	function( h, x ) {
		
		if( ncol( x ) > 2 ) stop( 
			"\nCannot set keys and values for a data.frame when there more than 2 columns."
		)

		if( ncol(x) == 2 ) set( h, x[[1]], x[[2]] )

	}
)



# SIGNATURE: list
setMethod(
	"set" ,
	signature( "hash", "list" ) ,
	function( h, x, y=NULL) {

		if( length(x) != 2 ) stop( 
			"\nCannot add from a list with more than two elements."
		)

		set( h, x[[1]], x[[2]] )
		
  }

)


# SIGNATURE: environment
setMethod( 
	"set" , 
	signature( "hash", "environment" ) ,
	function( h, x ) {
		keys<-ls(x)	
		sapply( keys , function(key) assign( key, get(key, env=x), env=h@x ) )
		return( invisible(0) )
	} 
)



# SIGNATURE: hash
setMethod( 
	"set", 
  signature( "hash", "hash" ) ,
  function( h, x ) {
		set( h, keys(x), values(x) )
	}
)
