% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_analysis.R
\name{analyze_questioned_documents}
\alias{analyze_questioned_documents}
\title{Analyze Questioned Documents}
\usage{
analyze_questioned_documents(
  main_dir,
  questioned_docs,
  model,
  num_cores,
  writer_indices,
  doc_indices
)
}
\arguments{
\item{main_dir}{A directory that contains a cluster template created by \code{\link[=make_clustering_template]{make_clustering_template()}}}

\item{questioned_docs}{A directory containing questioned documents}

\item{model}{A fitted model created by \code{\link[=fit_model]{fit_model()}}}

\item{num_cores}{An integer number of cores to use for parallel processing
with the \code{doParallel} package.}

\item{writer_indices}{A vector of start and stop characters for writer IDs in file names}

\item{doc_indices}{A vector of start and stop characters for document names in file names}
}
\value{
A list of likelihoods, votes, and posterior probabilities of
writership for each questioned document.
}
\description{
\code{analyze_questioned_documents()} estimates the posterior probability of
writership for the questioned documents using Markov Chain Monte Carlo (MCMC) draws from a hierarchical
model created with \code{\link[=fit_model]{fit_model()}}.
}
\examples{
\dontrun{
main_dir <- "/path/to/main_dir"
questioned_docs <- "/path/to/questioned_images"
analysis <- analyze_questioned_documents(
  main_dir = main_dir,
  questioned_docs = questioned_docs,
  model = model,
  num_cores = 2,
  writer_indices = c(2, 5),
  doc_indices = c(7, 18)
)
analysis$posterior_probabilities
}

}
