% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModeling_modelfunctions.R
\name{fit_model}
\alias{fit_model}
\title{Fit Model}
\usage{
fit_model(
  template_dir,
  model_images_dir,
  num_iters,
  num_chains = 1,
  num_cores,
  writer_indices,
  doc_indices,
  a = 2,
  b = 0.25,
  c = 2,
  d = 2,
  e = 0.5
)
}
\arguments{
\item{template_dir}{A directory that contains a cluster template created by
\code{\link[=make_clustering_templates]{make_clustering_templates()}}}

\item{model_images_dir}{A directory containing model training documents}

\item{num_iters}{An integer number of iterations of MCMC.}

\item{num_chains}{An integer number of chains to use.}

\item{num_cores}{An integer number of cores to use for parallel processing
clustering assignments. The model fitting is not done in parallel.}

\item{writer_indices}{A vector of the start and stop character of the writer
ID in the model training file names. E.g., if the file names are
writer0195_doc1, writer0210_doc1, writer0033_doc1 then writer_indices is
'c(7,10)'.}

\item{doc_indices}{A vector of the start and stop character of the "document
name" in the model training file names. This is used to distinguish between
two documents written by the same writer. E.g., if the file names are
writer0195_doc1, writer0195_doc2, writer0033_doc1, writer0033_doc2 then
doc_indices are 'c(12,15)'.}

\item{a}{The shape parameter for the Gamma distribution in the hierarchical
model}

\item{b}{The rate parameter for the Gamma distribution in the hierarchical
model}

\item{c}{The first shape parameter for the Beta distribution in the
hierarchical model}

\item{d}{The second shape parameter for the Beta distribution in the
hierarchical model}

\item{e}{The scale parameter for the hyper prior for mu in the hierarchical
model}
}
\value{
A list of training data used to fit the model and the fitted model
}
\description{
\code{fit_model()} fits a Bayesian hierarchical model to the model training data
in \code{model_images_dir} and draws samples from the model as Markov Chain Monte
Carlo (MCMC) estimates.
}
\examples{
\dontrun{
template_dir <- "/path/to/template_directory"
model_images_dir <- system.file("extdata/example_images/model_training_images",
  package = "handwriter"
)
questioned_images_dir <- system.file("extdata/example_images/questioned_images",
  package = "handwriter"
)

model <- fit_model(
  template_dir = template_dir,
  model_images_dir = model_images_dir,
  num_iters = 100,
  num_chains = 1,
  num_cores = 2,
  writer_indices = c(2, 5),
  doc_indices = c(7, 18)
)

model <- drop_burnin(model = model, burn_in = 25)

analysis <- analyze_questioned_documents(
  template_dir = template_dir,
  questioned_images_dir = questioned_images_dir,
  model = model,
  num_cores = 2
)
analysis$posterior_probabilities
}

}
