% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_gene.R
\name{autoplot.hagis.gene.summary}
\alias{autoplot.hagis.gene.summary}
\title{Plot hagis summary objects}
\usage{
\method{autoplot}{hagis.gene.summary}(object, type, color = NULL, order = NULL, ...)
}
\arguments{
\item{object}{a \code{hagis.gene.summary} object generated by \code{\link[=summarize_gene]{summarize_gene()}}.
Character.}

\item{type}{a vector of values for which the bar plot is desired. Specify
whether to return a graph of the percent pathogenic isolates, \code{percentage},
or as the count, \code{count}. Character.}

\item{color}{a named or hexadecimal color value to use for the bar color}

\item{order}{sort the x-axis of the bar chart by ascending or descending
order of \code{N_virulent_isolates} or \code{percent_pathogenic}. Accepts \code{ascending}
or \code{descending} input values. Defaults to \code{gene} name. Character.}

\item{...}{passed to the chosen \code{geom(s)}}
}
\value{
A \CRANpkg{ggplot2} plot
}
\description{
Creates a \CRANpkg{ggplot2} object of the gene summaries
calculated by \code{\link[=summarize_gene]{summarize_gene()}}
}
\examples{
# Using the built-in data set, P_sojae_survey
data(P_sojae_survey)

# calculate susceptibilities with a 60 \% cutoff value
susc <- summarize_gene(x = P_sojae_survey,
                       cutoff = 60,
                       control = "susceptible",
                       sample = "Isolate",
                       gene = "Rps",
                       perc_susc = "perc.susc")

# Visualize the summary of genes
autoplot(susc, type = "percentage")
}
