/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_ts_par6_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ts_par6");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_ts_par6");
    reader.add_event(227, 212, "end", "model_ts_par6");
    return reader;
}

#include <meta_header.hpp>
 class model_ts_par6 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > level1_choice;
    vector<vector<int> > level2_choice;
    vector<vector<int> > reward;
    double trans_prob;
public:
    model_ts_par6(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_ts_par6(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_ts_par6_namespace::model_ts_par6";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("level1_choice", "N", N);
            validate_non_negative_index("level1_choice", "T", T);
            context__.validate_dims("data initialization", "level1_choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("level1_choice", "N", N);
            validate_non_negative_index("level1_choice", "T", T);
            level1_choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("level1_choice");
            pos__ = 0;
            size_t level1_choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < level1_choice_limit_1__; ++i_1__) {
                size_t level1_choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < level1_choice_limit_0__; ++i_0__) {
                    level1_choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("level2_choice", "N", N);
            validate_non_negative_index("level2_choice", "T", T);
            context__.validate_dims("data initialization", "level2_choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("level2_choice", "N", N);
            validate_non_negative_index("level2_choice", "T", T);
            level2_choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("level2_choice");
            pos__ = 0;
            size_t level2_choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < level2_choice_limit_1__; ++i_1__) {
                size_t level2_choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < level2_choice_limit_0__; ++i_0__) {
                    level2_choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("reward", "N", N);
            validate_non_negative_index("reward", "T", T);
            context__.validate_dims("data initialization", "reward", "int", context__.to_vec(N,T));
            validate_non_negative_index("reward", "N", N);
            validate_non_negative_index("reward", "T", T);
            reward = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("reward");
            pos__ = 0;
            size_t reward_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < reward_limit_1__; ++i_1__) {
                size_t reward_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < reward_limit_0__; ++i_0__) {
                    reward[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "trans_prob", "double", context__.to_vec());
            trans_prob = double(0);
            vals_r__ = context__.vals_r("trans_prob");
            pos__ = 0;
            trans_prob = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"level1_choice[k0__][k1__]",level1_choice[k0__][k1__],1);
                    check_less_or_equal(function__,"level1_choice[k0__][k1__]",level1_choice[k0__][k1__],2);
                }
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"level2_choice[k0__][k1__]",level2_choice[k0__][k1__],1);
                    check_less_or_equal(function__,"level2_choice[k0__][k1__]",level2_choice[k0__][k1__],4);
                }
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"reward[k0__][k1__]",reward[k0__][k1__],0);
                    check_less_or_equal(function__,"reward[k0__][k1__]",reward[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"trans_prob",trans_prob,0);
            check_less_or_equal(function__,"trans_prob",trans_prob,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 30;
            validate_non_negative_index("mu_pr", "6", 6);
            num_params_r__ += 6;
            current_statement_begin__ = 31;
            validate_non_negative_index("sigma", "6", 6);
            num_params_r__ += 6;
            current_statement_begin__ = 34;
            validate_non_negative_index("a1_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 35;
            validate_non_negative_index("beta1_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 36;
            validate_non_negative_index("a2_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 37;
            validate_non_negative_index("beta2_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 38;
            validate_non_negative_index("pi_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 39;
            validate_non_negative_index("w_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_ts_par6() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "6", 6);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(6));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "6", 6);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(6));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("a1_pr")))
            throw std::runtime_error("variable a1_pr missing");
        vals_r__ = context__.vals_r("a1_pr");
        pos__ = 0U;
        validate_non_negative_index("a1_pr", "N", N);
        context__.validate_dims("initialization", "a1_pr", "vector_d", context__.to_vec(N));
        vector_d a1_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            a1_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(a1_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable a1_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta1_pr")))
            throw std::runtime_error("variable beta1_pr missing");
        vals_r__ = context__.vals_r("beta1_pr");
        pos__ = 0U;
        validate_non_negative_index("beta1_pr", "N", N);
        context__.validate_dims("initialization", "beta1_pr", "vector_d", context__.to_vec(N));
        vector_d beta1_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta1_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta1_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta1_pr: ") + e.what());
        }

        if (!(context__.contains_r("a2_pr")))
            throw std::runtime_error("variable a2_pr missing");
        vals_r__ = context__.vals_r("a2_pr");
        pos__ = 0U;
        validate_non_negative_index("a2_pr", "N", N);
        context__.validate_dims("initialization", "a2_pr", "vector_d", context__.to_vec(N));
        vector_d a2_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            a2_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(a2_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable a2_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta2_pr")))
            throw std::runtime_error("variable beta2_pr missing");
        vals_r__ = context__.vals_r("beta2_pr");
        pos__ = 0U;
        validate_non_negative_index("beta2_pr", "N", N);
        context__.validate_dims("initialization", "beta2_pr", "vector_d", context__.to_vec(N));
        vector_d beta2_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta2_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta2_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        validate_non_negative_index("pi_pr", "N", N);
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("w_pr")))
            throw std::runtime_error("variable w_pr missing");
        vals_r__ = context__.vals_r("w_pr");
        pos__ = 0U;
        validate_non_negative_index("w_pr", "N", N);
        context__.validate_dims("initialization", "w_pr", "vector_d", context__.to_vec(N));
        vector_d w_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(6,lp__);
            else
                mu_pr = in__.vector_constrain(6);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,6,lp__);
            else
                sigma = in__.vector_lb_constrain(0,6);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a1_pr;
            (void) a1_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                a1_pr = in__.vector_constrain(N,lp__);
            else
                a1_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta1_pr;
            (void) beta1_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta1_pr = in__.vector_constrain(N,lp__);
            else
                beta1_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a2_pr;
            (void) a2_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                a2_pr = in__.vector_constrain(N,lp__);
            else
                a2_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta2_pr;
            (void) beta2_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta2_pr = in__.vector_constrain(N,lp__);
            else
                beta2_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi_pr;
            (void) pi_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                pi_pr = in__.vector_constrain(N,lp__);
            else
                pi_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w_pr;
            (void) w_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                w_pr = in__.vector_constrain(N,lp__);
            else
                w_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 43;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a1(static_cast<Eigen::VectorXd::Index>(N));
            (void) a1;  // dummy to suppress unused var warning

            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("beta1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta1(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta1;  // dummy to suppress unused var warning

            stan::math::initialize(beta1, DUMMY_VAR__);
            stan::math::fill(beta1,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a2(static_cast<Eigen::VectorXd::Index>(N));
            (void) a2;  // dummy to suppress unused var warning

            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("beta2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta2(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta2;  // dummy to suppress unused var warning

            stan::math::initialize(beta2, DUMMY_VAR__);
            stan::math::fill(beta2,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("pi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi;  // dummy to suppress unused var warning

            stan::math::initialize(pi, DUMMY_VAR__);
            stan::math::fill(pi,DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("w", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w(static_cast<Eigen::VectorXd::Index>(N));
            (void) w;  // dummy to suppress unused var warning

            stan::math::initialize(w, DUMMY_VAR__);
            stan::math::fill(w,DUMMY_VAR__);


            current_statement_begin__ = 50;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 51;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(a1_pr,i,"a1_pr",1)))), 
                            "assigning variable a1");
                current_statement_begin__ = 52;
                stan::model::assign(beta1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::exp((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta1_pr,i,"beta1_pr",1)))), 
                            "assigning variable beta1");
                current_statement_begin__ = 53;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(a2_pr,i,"a2_pr",1)))), 
                            "assigning variable a2");
                current_statement_begin__ = 54;
                stan::model::assign(beta2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::exp((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(beta2_pr,i,"beta2_pr",1)))), 
                            "assigning variable beta2");
                current_statement_begin__ = 55;
                stan::model::assign(pi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(pi_pr,i,"pi_pr",1)))) * 5), 
                            "assigning variable pi");
                current_statement_begin__ = 56;
                stan::model::assign(w, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,6,"mu_pr",1) + (get_base1(sigma,6,"sigma",1) * get_base1(w_pr,i,"w_pr",1)))), 
                            "assigning variable w");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(a1(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a1" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta1(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta1" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(a2(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a2" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta2(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta2" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(pi(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(w(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: w" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"a1",a1,0);
            check_less_or_equal(function__,"a1",a1,1);
            current_statement_begin__ = 44;
            check_greater_or_equal(function__,"beta1",beta1,0);
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"a2",a2,0);
            check_less_or_equal(function__,"a2",a2,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"beta2",beta2,0);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"pi",pi,0);
            check_less_or_equal(function__,"pi",pi,5);
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"w",w,0);
            check_less_or_equal(function__,"w",w,1);

            // model body

            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(a1_pr, 0, 1));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(beta1_pr, 0, 1));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(a2_pr, 0, 1));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(beta2_pr, 0, 1));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(w_pr, 0, 1));
            current_statement_begin__ = 72;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 74;
                validate_non_negative_index("v_mb", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_mb(static_cast<Eigen::VectorXd::Index>(2));
                (void) v_mb;  // dummy to suppress unused var warning

                stan::math::initialize(v_mb, DUMMY_VAR__);
                stan::math::fill(v_mb,DUMMY_VAR__);
                current_statement_begin__ = 75;
                validate_non_negative_index("v_mf", "6", 6);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_mf(static_cast<Eigen::VectorXd::Index>(6));
                (void) v_mf;  // dummy to suppress unused var warning

                stan::math::initialize(v_mf, DUMMY_VAR__);
                stan::math::fill(v_mf,DUMMY_VAR__);
                current_statement_begin__ = 76;
                validate_non_negative_index("v_hybrid", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_hybrid(static_cast<Eigen::VectorXd::Index>(2));
                (void) v_hybrid;  // dummy to suppress unused var warning

                stan::math::initialize(v_hybrid, DUMMY_VAR__);
                stan::math::fill(v_hybrid,DUMMY_VAR__);
                current_statement_begin__ = 77;
                local_scalar_t__ level1_prob_choice2;
                (void) level1_prob_choice2;  // dummy to suppress unused var warning

                stan::math::initialize(level1_prob_choice2, DUMMY_VAR__);
                stan::math::fill(level1_prob_choice2,DUMMY_VAR__);
                current_statement_begin__ = 78;
                local_scalar_t__ level2_prob_choice2;
                (void) level2_prob_choice2;  // dummy to suppress unused var warning

                stan::math::initialize(level2_prob_choice2, DUMMY_VAR__);
                stan::math::fill(level2_prob_choice2,DUMMY_VAR__);
                current_statement_begin__ = 79;
                int level1_choice_01(0);
                (void) level1_choice_01;  // dummy to suppress unused var warning

                stan::math::fill(level1_choice_01, std::numeric_limits<int>::min());
                current_statement_begin__ = 80;
                int level2_choice_01(0);
                (void) level2_choice_01;  // dummy to suppress unused var warning

                stan::math::fill(level2_choice_01, std::numeric_limits<int>::min());


                current_statement_begin__ = 83;
                stan::math::assign(v_mb, rep_vector(0.0,2));
                current_statement_begin__ = 84;
                stan::math::assign(v_mf, rep_vector(0.0,6));
                current_statement_begin__ = 85;
                stan::math::assign(v_hybrid, rep_vector(0.0,2));
                current_statement_begin__ = 87;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 89;
                    stan::model::assign(v_mb, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                ((trans_prob * stan::math::fmax(get_base1(v_mf,3,"v_mf",1),get_base1(v_mf,4,"v_mf",1))) + ((1 - trans_prob) * stan::math::fmax(get_base1(v_mf,5,"v_mf",1),get_base1(v_mf,6,"v_mf",1)))), 
                                "assigning variable v_mb");
                    current_statement_begin__ = 90;
                    stan::model::assign(v_mb, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (((1 - trans_prob) * stan::math::fmax(get_base1(v_mf,3,"v_mf",1),get_base1(v_mf,4,"v_mf",1))) + (trans_prob * stan::math::fmax(get_base1(v_mf,5,"v_mf",1),get_base1(v_mf,6,"v_mf",1)))), 
                                "assigning variable v_mb");
                    current_statement_begin__ = 93;
                    stan::model::assign(v_hybrid, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                ((get_base1(w,i,"w",1) * get_base1(v_mb,1,"v_mb",1)) + ((1 - get_base1(w,i,"w",1)) * get_base1(v_mf,1,"v_mf",1))), 
                                "assigning variable v_hybrid");
                    current_statement_begin__ = 94;
                    stan::model::assign(v_hybrid, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                ((get_base1(w,i,"w",1) * get_base1(v_mb,2,"v_mb",1)) + ((1 - get_base1(w,i,"w",1)) * get_base1(v_mf,2,"v_mf",1))), 
                                "assigning variable v_hybrid");
                    current_statement_begin__ = 98;
                    stan::math::assign(level1_choice_01, (get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2) - 1));
                    current_statement_begin__ = 99;
                    if (as_bool(logical_eq(t,1))) {

                        current_statement_begin__ = 100;
                        stan::math::assign(level1_prob_choice2, inv_logit((get_base1(beta1,i,"beta1",1) * (get_base1(v_hybrid,2,"v_hybrid",1) - get_base1(v_hybrid,1,"v_hybrid",1)))));
                    } else {

                        current_statement_begin__ = 102;
                        stan::math::assign(level1_prob_choice2, inv_logit(((get_base1(beta1,i,"beta1",1) * (get_base1(v_hybrid,2,"v_hybrid",1) - get_base1(v_hybrid,1,"v_hybrid",1))) + (get_base1(pi,i,"pi",1) * ((2 * get_base1(get_base1(level1_choice,i,"level1_choice",1),(t - 1),"level1_choice",2)) - 3)))));
                    }
                    current_statement_begin__ = 104;
                    lp_accum__.add(bernoulli_log<propto__>(level1_choice_01, level1_prob_choice2));
                    current_statement_begin__ = 107;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), "v_mf") + (get_base1(a1,i,"a1",1) * (get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1) - get_base1(v_mf,get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2),"v_mf",1)))), 
                                "assigning variable v_mf");
                    current_statement_begin__ = 110;
                    stan::math::assign(level2_choice_01, (1 - modulus(get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2),2)));
                    current_statement_begin__ = 111;
                    if (as_bool(logical_gt(get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2),2))) {

                        current_statement_begin__ = 112;
                        stan::math::assign(level2_prob_choice2, inv_logit((get_base1(beta2,i,"beta2",1) * (get_base1(v_mf,6,"v_mf",1) - get_base1(v_mf,5,"v_mf",1)))));
                    } else {

                        current_statement_begin__ = 114;
                        stan::math::assign(level2_prob_choice2, inv_logit((get_base1(beta2,i,"beta2",1) * (get_base1(v_mf,4,"v_mf",1) - get_base1(v_mf,3,"v_mf",1)))));
                    }
                    current_statement_begin__ = 116;
                    lp_accum__.add(bernoulli_log<propto__>(level2_choice_01, level2_prob_choice2));
                    current_statement_begin__ = 120;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni((2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2))), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni((2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2))), stan::model::nil_index_list()), "v_mf") + (get_base1(a2,i,"a2",1) * (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1)))), 
                                "assigning variable v_mf");
                    current_statement_begin__ = 123;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), "v_mf") + (get_base1(a1,i,"a1",1) * (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1)))), 
                                "assigning variable v_mf");
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("a1_pr");
        names__.push_back("beta1_pr");
        names__.push_back("a2_pr");
        names__.push_back("beta2_pr");
        names__.push_back("pi_pr");
        names__.push_back("w_pr");
        names__.push_back("a1");
        names__.push_back("beta1");
        names__.push_back("a2");
        names__.push_back("beta2");
        names__.push_back("pi");
        names__.push_back("w");
        names__.push_back("mu_a1");
        names__.push_back("mu_beta1");
        names__.push_back("mu_a2");
        names__.push_back("mu_beta2");
        names__.push_back("mu_pi");
        names__.push_back("mu_w");
        names__.push_back("log_lik");
        names__.push_back("y_pred_step1");
        names__.push_back("y_pred_step2");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_ts_par6_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(6);
        vector_d sigma = in__.vector_lb_constrain(0,6);
        vector_d a1_pr = in__.vector_constrain(N);
        vector_d beta1_pr = in__.vector_constrain(N);
        vector_d a2_pr = in__.vector_constrain(N);
        vector_d beta2_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d w_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(a1_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta1_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(a2_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta2_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 43;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a1(static_cast<Eigen::VectorXd::Index>(N));
            (void) a1;  // dummy to suppress unused var warning

            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("beta1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta1(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta1;  // dummy to suppress unused var warning

            stan::math::initialize(beta1, DUMMY_VAR__);
            stan::math::fill(beta1,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  a2(static_cast<Eigen::VectorXd::Index>(N));
            (void) a2;  // dummy to suppress unused var warning

            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("beta2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta2(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta2;  // dummy to suppress unused var warning

            stan::math::initialize(beta2, DUMMY_VAR__);
            stan::math::fill(beta2,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("pi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi;  // dummy to suppress unused var warning

            stan::math::initialize(pi, DUMMY_VAR__);
            stan::math::fill(pi,DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("w", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w(static_cast<Eigen::VectorXd::Index>(N));
            (void) w;  // dummy to suppress unused var warning

            stan::math::initialize(w, DUMMY_VAR__);
            stan::math::fill(w,DUMMY_VAR__);


            current_statement_begin__ = 50;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 51;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(a1_pr,i,"a1_pr",1)))), 
                            "assigning variable a1");
                current_statement_begin__ = 52;
                stan::model::assign(beta1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::exp((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta1_pr,i,"beta1_pr",1)))), 
                            "assigning variable beta1");
                current_statement_begin__ = 53;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(a2_pr,i,"a2_pr",1)))), 
                            "assigning variable a2");
                current_statement_begin__ = 54;
                stan::model::assign(beta2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::exp((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(beta2_pr,i,"beta2_pr",1)))), 
                            "assigning variable beta2");
                current_statement_begin__ = 55;
                stan::model::assign(pi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(pi_pr,i,"pi_pr",1)))) * 5), 
                            "assigning variable pi");
                current_statement_begin__ = 56;
                stan::model::assign(w, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,6,"mu_pr",1) + (get_base1(sigma,6,"sigma",1) * get_base1(w_pr,i,"w_pr",1)))), 
                            "assigning variable w");
            }

            // validate transformed parameters
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"a1",a1,0);
            check_less_or_equal(function__,"a1",a1,1);
            current_statement_begin__ = 44;
            check_greater_or_equal(function__,"beta1",beta1,0);
            current_statement_begin__ = 45;
            check_greater_or_equal(function__,"a2",a2,0);
            check_less_or_equal(function__,"a2",a2,1);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"beta2",beta2,0);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"pi",pi,0);
            check_less_or_equal(function__,"pi",pi,5);
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"w",w,0);
            check_less_or_equal(function__,"w",w,1);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(a1[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta1[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(a2[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta2[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 131;
            local_scalar_t__ mu_a1;
            (void) mu_a1;  // dummy to suppress unused var warning

            stan::math::initialize(mu_a1, DUMMY_VAR__);
            stan::math::fill(mu_a1,DUMMY_VAR__);
            current_statement_begin__ = 132;
            local_scalar_t__ mu_beta1;
            (void) mu_beta1;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta1, DUMMY_VAR__);
            stan::math::fill(mu_beta1,DUMMY_VAR__);
            current_statement_begin__ = 133;
            local_scalar_t__ mu_a2;
            (void) mu_a2;  // dummy to suppress unused var warning

            stan::math::initialize(mu_a2, DUMMY_VAR__);
            stan::math::fill(mu_a2,DUMMY_VAR__);
            current_statement_begin__ = 134;
            local_scalar_t__ mu_beta2;
            (void) mu_beta2;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta2, DUMMY_VAR__);
            stan::math::fill(mu_beta2,DUMMY_VAR__);
            current_statement_begin__ = 135;
            local_scalar_t__ mu_pi;
            (void) mu_pi;  // dummy to suppress unused var warning

            stan::math::initialize(mu_pi, DUMMY_VAR__);
            stan::math::fill(mu_pi,DUMMY_VAR__);
            current_statement_begin__ = 136;
            local_scalar_t__ mu_w;
            (void) mu_w;  // dummy to suppress unused var warning

            stan::math::initialize(mu_w, DUMMY_VAR__);
            stan::math::fill(mu_w,DUMMY_VAR__);
            current_statement_begin__ = 139;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 142;
            validate_non_negative_index("y_pred_step1", "N", N);
            validate_non_negative_index("y_pred_step1", "T", T);
            vector<vector<local_scalar_t__> > y_pred_step1(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred_step1, DUMMY_VAR__);
            stan::math::fill(y_pred_step1,DUMMY_VAR__);
            current_statement_begin__ = 143;
            validate_non_negative_index("y_pred_step2", "N", N);
            validate_non_negative_index("y_pred_step2", "T", T);
            vector<vector<local_scalar_t__> > y_pred_step2(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred_step2, DUMMY_VAR__);
            stan::math::fill(y_pred_step2,DUMMY_VAR__);


            current_statement_begin__ = 146;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 147;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 148;
                    stan::model::assign(y_pred_step1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred_step1");
                    current_statement_begin__ = 149;
                    stan::model::assign(y_pred_step2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred_step2");
                }
            }
            current_statement_begin__ = 154;
            stan::math::assign(mu_a1, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 155;
            stan::math::assign(mu_beta1, stan::math::exp(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 156;
            stan::math::assign(mu_a2, Phi_approx(get_base1(mu_pr,3,"mu_pr",1)));
            current_statement_begin__ = 157;
            stan::math::assign(mu_beta2, stan::math::exp(get_base1(mu_pr,4,"mu_pr",1)));
            current_statement_begin__ = 158;
            stan::math::assign(mu_pi, (Phi_approx(get_base1(mu_pr,5,"mu_pr",1)) * 5));
            current_statement_begin__ = 159;
            stan::math::assign(mu_w, Phi_approx(get_base1(mu_pr,6,"mu_pr",1)));

            current_statement_begin__ = 162;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 164;
                validate_non_negative_index("v_mb", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_mb(static_cast<Eigen::VectorXd::Index>(2));
                (void) v_mb;  // dummy to suppress unused var warning

                stan::math::initialize(v_mb, DUMMY_VAR__);
                stan::math::fill(v_mb,DUMMY_VAR__);
                current_statement_begin__ = 165;
                validate_non_negative_index("v_mf", "6", 6);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_mf(static_cast<Eigen::VectorXd::Index>(6));
                (void) v_mf;  // dummy to suppress unused var warning

                stan::math::initialize(v_mf, DUMMY_VAR__);
                stan::math::fill(v_mf,DUMMY_VAR__);
                current_statement_begin__ = 166;
                validate_non_negative_index("v_hybrid", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  v_hybrid(static_cast<Eigen::VectorXd::Index>(2));
                (void) v_hybrid;  // dummy to suppress unused var warning

                stan::math::initialize(v_hybrid, DUMMY_VAR__);
                stan::math::fill(v_hybrid,DUMMY_VAR__);
                current_statement_begin__ = 167;
                local_scalar_t__ level1_prob_choice2;
                (void) level1_prob_choice2;  // dummy to suppress unused var warning

                stan::math::initialize(level1_prob_choice2, DUMMY_VAR__);
                stan::math::fill(level1_prob_choice2,DUMMY_VAR__);
                current_statement_begin__ = 168;
                local_scalar_t__ level2_prob_choice2;
                (void) level2_prob_choice2;  // dummy to suppress unused var warning

                stan::math::initialize(level2_prob_choice2, DUMMY_VAR__);
                stan::math::fill(level2_prob_choice2,DUMMY_VAR__);
                current_statement_begin__ = 169;
                int level1_choice_01(0);
                (void) level1_choice_01;  // dummy to suppress unused var warning

                stan::math::fill(level1_choice_01, std::numeric_limits<int>::min());
                current_statement_begin__ = 170;
                int level2_choice_01(0);
                (void) level2_choice_01;  // dummy to suppress unused var warning

                stan::math::fill(level2_choice_01, std::numeric_limits<int>::min());


                current_statement_begin__ = 173;
                stan::math::assign(v_mb, rep_vector(0.0,2));
                current_statement_begin__ = 174;
                stan::math::assign(v_mf, rep_vector(0.0,6));
                current_statement_begin__ = 175;
                stan::math::assign(v_hybrid, rep_vector(0.0,2));
                current_statement_begin__ = 177;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 179;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 181;
                    stan::model::assign(v_mb, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                ((trans_prob * stan::math::fmax(get_base1(v_mf,3,"v_mf",1),get_base1(v_mf,4,"v_mf",1))) + ((1 - trans_prob) * stan::math::fmax(get_base1(v_mf,5,"v_mf",1),get_base1(v_mf,6,"v_mf",1)))), 
                                "assigning variable v_mb");
                    current_statement_begin__ = 182;
                    stan::model::assign(v_mb, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (((1 - trans_prob) * stan::math::fmax(get_base1(v_mf,3,"v_mf",1),get_base1(v_mf,4,"v_mf",1))) + (trans_prob * stan::math::fmax(get_base1(v_mf,5,"v_mf",1),get_base1(v_mf,6,"v_mf",1)))), 
                                "assigning variable v_mb");
                    current_statement_begin__ = 185;
                    stan::model::assign(v_hybrid, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                ((get_base1(w,i,"w",1) * get_base1(v_mb,1,"v_mb",1)) + ((1 - get_base1(w,i,"w",1)) * get_base1(v_mf,1,"v_mf",1))), 
                                "assigning variable v_hybrid");
                    current_statement_begin__ = 186;
                    stan::model::assign(v_hybrid, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                ((get_base1(w,i,"w",1) * get_base1(v_mb,2,"v_mb",1)) + ((1 - get_base1(w,i,"w",1)) * get_base1(v_mf,2,"v_mf",1))), 
                                "assigning variable v_hybrid");
                    current_statement_begin__ = 190;
                    stan::math::assign(level1_choice_01, (get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2) - 1));
                    current_statement_begin__ = 191;
                    if (as_bool(logical_eq(t,1))) {

                        current_statement_begin__ = 192;
                        stan::math::assign(level1_prob_choice2, inv_logit((get_base1(beta1,i,"beta1",1) * (get_base1(v_hybrid,2,"v_hybrid",1) - get_base1(v_hybrid,1,"v_hybrid",1)))));
                    } else {

                        current_statement_begin__ = 194;
                        stan::math::assign(level1_prob_choice2, inv_logit(((get_base1(beta1,i,"beta1",1) * (get_base1(v_hybrid,2,"v_hybrid",1) - get_base1(v_hybrid,1,"v_hybrid",1))) + (get_base1(pi,i,"pi",1) * ((2 * get_base1(get_base1(level1_choice,i,"level1_choice",1),(t - 1),"level1_choice",2)) - 3)))));
                    }
                    current_statement_begin__ = 196;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_log(level1_choice_01,level1_prob_choice2)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 199;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), "v_mf") + (get_base1(a1,i,"a1",1) * (get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1) - get_base1(v_mf,get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2),"v_mf",1)))), 
                                "assigning variable v_mf");
                    current_statement_begin__ = 202;
                    stan::math::assign(level2_choice_01, (1 - modulus(get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2),2)));
                    current_statement_begin__ = 204;
                    if (as_bool(logical_gt(get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2),2))) {

                        current_statement_begin__ = 205;
                        stan::math::assign(level2_prob_choice2, inv_logit((get_base1(beta2,i,"beta2",1) * (get_base1(v_mf,6,"v_mf",1) - get_base1(v_mf,5,"v_mf",1)))));
                    } else {

                        current_statement_begin__ = 207;
                        stan::math::assign(level2_prob_choice2, inv_logit((get_base1(beta2,i,"beta2",1) * (get_base1(v_mf,4,"v_mf",1) - get_base1(v_mf,3,"v_mf",1)))));
                    }
                    current_statement_begin__ = 209;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_log(level2_choice_01,level2_prob_choice2)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 212;
                    stan::model::assign(y_pred_step1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(level1_prob_choice2, base_rng__), 
                                "assigning variable y_pred_step1");
                    current_statement_begin__ = 213;
                    stan::model::assign(y_pred_step2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(level2_prob_choice2, base_rng__), 
                                "assigning variable y_pred_step2");
                    current_statement_begin__ = 217;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni((2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2))), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni((2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2))), stan::model::nil_index_list()), "v_mf") + (get_base1(a2,i,"a2",1) * (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1)))), 
                                "assigning variable v_mf");
                    current_statement_begin__ = 220;
                    stan::model::assign(v_mf, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(v_mf, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(level1_choice,i,"level1_choice",1),t,"level1_choice",2)), stan::model::nil_index_list()), "v_mf") + (get_base1(a1,i,"a1",1) * (get_base1(get_base1(reward,i,"reward",1),t,"reward",2) - get_base1(v_mf,(2 + get_base1(get_base1(level2_choice,i,"level2_choice",1),t,"level2_choice",2)),"v_mf",1)))), 
                                "assigning variable v_mf");
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 131;
            check_greater_or_equal(function__,"mu_a1",mu_a1,0);
            check_less_or_equal(function__,"mu_a1",mu_a1,1);
            current_statement_begin__ = 132;
            check_greater_or_equal(function__,"mu_beta1",mu_beta1,0);
            current_statement_begin__ = 133;
            check_greater_or_equal(function__,"mu_a2",mu_a2,0);
            check_less_or_equal(function__,"mu_a2",mu_a2,1);
            current_statement_begin__ = 134;
            check_greater_or_equal(function__,"mu_beta2",mu_beta2,0);
            current_statement_begin__ = 135;
            check_greater_or_equal(function__,"mu_pi",mu_pi,0);
            check_less_or_equal(function__,"mu_pi",mu_pi,5);
            current_statement_begin__ = 136;
            check_greater_or_equal(function__,"mu_w",mu_w,0);
            check_less_or_equal(function__,"mu_w",mu_w,1);
            current_statement_begin__ = 139;
            current_statement_begin__ = 142;
            current_statement_begin__ = 143;

            // write generated quantities
        vars__.push_back(mu_a1);
        vars__.push_back(mu_beta1);
        vars__.push_back(mu_a2);
        vars__.push_back(mu_beta2);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_w);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred_step1[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred_step2[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ts_par6";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_a1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_a2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred_step1" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred_step2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_a1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_a2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred_step1" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred_step2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_ts_par6_namespace::model_ts_par6 stan_model;


#endif
