/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_gng_m3_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_gng_m3");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_gng_m3");
    reader.add_event(193, 178, "end", "model_gng_m3");
    return reader;
}

#include <meta_header.hpp>
 class model_gng_m3 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > cue;
    vector<vector<int> > pressed;
    vector<vector<double> > outcome;
    vector_d initV;
public:
    model_gng_m3(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_gng_m3(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m3_namespace::model_gng_m3";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("cue", "N", N);
            validate_non_negative_index("cue", "T", T);
            context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
            validate_non_negative_index("cue", "N", N);
            validate_non_negative_index("cue", "T", T);
            cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("cue");
            pos__ = 0;
            size_t cue_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
                size_t cue_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                    cue[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("pressed", "N", N);
            validate_non_negative_index("pressed", "T", T);
            context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
            validate_non_negative_index("pressed", "N", N);
            validate_non_negative_index("pressed", "T", T);
            pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("pressed");
            pos__ = 0;
            size_t pressed_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
                size_t pressed_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                    pressed[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("outcome");
            pos__ = 0;
            size_t outcome_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
                size_t outcome_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                    outcome[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                    check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
                }
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],-(1));
                    check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 22;
            // initialize data variables
            current_statement_begin__ = 26;
            validate_non_negative_index("initV", "4", 4);
            initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
            stan::math::fill(initV,DUMMY_VAR__);

            current_statement_begin__ = 27;
            stan::math::assign(initV, rep_vector(0.0,4));

            // validate transformed data
            current_statement_begin__ = 26;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 32;
            validate_non_negative_index("mu_pr", "5", 5);
            num_params_r__ += 5;
            current_statement_begin__ = 33;
            validate_non_negative_index("sigma", "5", 5);
            num_params_r__ += 5;
            current_statement_begin__ = 34;
            validate_non_negative_index("xi_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 35;
            validate_non_negative_index("ep_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 36;
            validate_non_negative_index("b_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 37;
            validate_non_negative_index("pi_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 38;
            validate_non_negative_index("rho_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_gng_m3() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "5", 5);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(5));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "5", 5);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(5));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        validate_non_negative_index("xi_pr", "N", N);
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        validate_non_negative_index("ep_pr", "N", N);
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        validate_non_negative_index("b_pr", "N", N);
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        validate_non_negative_index("pi_pr", "N", N);
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        validate_non_negative_index("rho_pr", "N", N);
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(5,lp__);
            else
                mu_pr = in__.vector_constrain(5);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,5,lp__);
            else
                sigma = in__.vector_lb_constrain(0,5);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi_pr;
            (void) xi_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                xi_pr = in__.vector_constrain(N,lp__);
            else
                xi_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ep_pr;
            (void) ep_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                ep_pr = in__.vector_constrain(N,lp__);
            else
                ep_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b_pr;
            (void) b_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                b_pr = in__.vector_constrain(N,lp__);
            else
                b_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi_pr;
            (void) pi_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                pi_pr = in__.vector_constrain(N,lp__);
            else
                pi_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho_pr;
            (void) rho_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                rho_pr = in__.vector_constrain(N,lp__);
            else
                rho_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 42;
            validate_non_negative_index("xi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
            (void) xi;  // dummy to suppress unused var warning

            stan::math::initialize(xi, DUMMY_VAR__);
            stan::math::fill(xi,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("ep", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
            (void) ep;  // dummy to suppress unused var warning

            stan::math::initialize(ep, DUMMY_VAR__);
            stan::math::fill(ep,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
            (void) b;  // dummy to suppress unused var warning

            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("pi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi;  // dummy to suppress unused var warning

            stan::math::initialize(pi, DUMMY_VAR__);
            stan::math::fill(pi,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("rho", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
            (void) rho;  // dummy to suppress unused var warning

            stan::math::initialize(rho, DUMMY_VAR__);
            stan::math::fill(rho,DUMMY_VAR__);


            current_statement_begin__ = 48;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 49;
                stan::model::assign(xi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))), 
                            "assigning variable xi");
                current_statement_begin__ = 50;
                stan::model::assign(ep, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))), 
                            "assigning variable ep");
            }
            current_statement_begin__ = 52;
            stan::math::assign(b, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            current_statement_begin__ = 53;
            stan::math::assign(pi, add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            current_statement_begin__ = 54;
            stan::math::assign(rho, stan::math::exp(add(get_base1(mu_pr,5,"mu_pr",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(xi(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(ep(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(b(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(pi(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(rho(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"xi",xi,0);
            check_less_or_equal(function__,"xi",xi,1);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"ep",ep,0);
            check_less_or_equal(function__,"ep",ep,1);
            current_statement_begin__ = 44;
            current_statement_begin__ = 45;
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"rho",rho,0);

            // model body

            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(get_base1(mu_pr,1,"mu_pr",1), 0, 1.0));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(get_base1(mu_pr,2,"mu_pr",1), 0, 1.0));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(get_base1(mu_pr,3,"mu_pr",1), 0, 10.0));
            current_statement_begin__ = 63;
            lp_accum__.add(normal_log<propto__>(get_base1(mu_pr,4,"mu_pr",1), 0, 10.0));
            current_statement_begin__ = 64;
            lp_accum__.add(normal_log<propto__>(get_base1(mu_pr,5,"mu_pr",1), 0, 1.0));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_min_max(1, 2), stan::model::nil_index_list()), "sigma"), 0, 0.20000000000000001));
            current_statement_begin__ = 66;
            lp_accum__.add(cauchy_log<propto__>(stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_min_max(3, 4), stan::model::nil_index_list()), "sigma"), 0, 1.0));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(get_base1(sigma,5,"sigma",1), 0, 0.20000000000000001));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1.0));
            current_statement_begin__ = 74;
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            current_statement_begin__ = 76;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 77;
                validate_non_negative_index("wv_g", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                (void) wv_g;  // dummy to suppress unused var warning

                stan::math::initialize(wv_g, DUMMY_VAR__);
                stan::math::fill(wv_g,DUMMY_VAR__);
                current_statement_begin__ = 78;
                validate_non_negative_index("wv_ng", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                (void) wv_ng;  // dummy to suppress unused var warning

                stan::math::initialize(wv_ng, DUMMY_VAR__);
                stan::math::fill(wv_ng,DUMMY_VAR__);
                current_statement_begin__ = 79;
                validate_non_negative_index("qv_g", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                (void) qv_g;  // dummy to suppress unused var warning

                stan::math::initialize(qv_g, DUMMY_VAR__);
                stan::math::fill(qv_g,DUMMY_VAR__);
                current_statement_begin__ = 80;
                validate_non_negative_index("qv_ng", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                (void) qv_ng;  // dummy to suppress unused var warning

                stan::math::initialize(qv_ng, DUMMY_VAR__);
                stan::math::fill(qv_ng,DUMMY_VAR__);
                current_statement_begin__ = 81;
                validate_non_negative_index("sv", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                (void) sv;  // dummy to suppress unused var warning

                stan::math::initialize(sv, DUMMY_VAR__);
                stan::math::fill(sv,DUMMY_VAR__);
                current_statement_begin__ = 82;
                validate_non_negative_index("pGo", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                (void) pGo;  // dummy to suppress unused var warning

                stan::math::initialize(pGo, DUMMY_VAR__);
                stan::math::fill(pGo,DUMMY_VAR__);


                current_statement_begin__ = 84;
                stan::math::assign(wv_g, initV);
                current_statement_begin__ = 85;
                stan::math::assign(wv_ng, initV);
                current_statement_begin__ = 86;
                stan::math::assign(qv_g, initV);
                current_statement_begin__ = 87;
                stan::math::assign(qv_ng, initV);
                current_statement_begin__ = 88;
                stan::math::assign(sv, initV);
                current_statement_begin__ = 90;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 91;
                    stan::model::assign(wv_g, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))), 
                                "assigning variable wv_g");
                    current_statement_begin__ = 92;
                    stan::model::assign(wv_ng, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), 
                                "assigning variable wv_ng");
                    current_statement_begin__ = 93;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))), 
                                "assigning variable pGo");

                    current_statement_begin__ = 95;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(pGo, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "pGo") * (1 - get_base1(xi,i,"xi",1))), 
                                "assigning variable pGo");
                    current_statement_begin__ = 96;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(pGo, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "pGo") + (get_base1(xi,i,"xi",1) / 2)), 
                                "assigning variable pGo");
                    current_statement_begin__ = 98;
                    lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                    current_statement_begin__ = 101;
                    stan::model::assign(sv, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(sv, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "sv") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))), 
                                "assigning variable sv");
                    current_statement_begin__ = 104;
                    if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                        current_statement_begin__ = 105;
                        stan::model::assign(qv_g, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(qv_g, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "qv_g") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))), 
                                    "assigning variable qv_g");
                    } else {

                        current_statement_begin__ = 107;
                        stan::model::assign(qv_ng, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(qv_ng, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "qv_ng") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))), 
                                    "assigning variable qv_ng");
                    }
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("pi_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("pi");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_pi");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
        names__.push_back("Qgo");
        names__.push_back("Qnogo");
        names__.push_back("Wgo");
        names__.push_back("Wnogo");
        names__.push_back("SV");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m3_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(5);
        vector_d sigma = in__.vector_lb_constrain(0,5);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 42;
            validate_non_negative_index("xi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
            (void) xi;  // dummy to suppress unused var warning

            stan::math::initialize(xi, DUMMY_VAR__);
            stan::math::fill(xi,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("ep", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
            (void) ep;  // dummy to suppress unused var warning

            stan::math::initialize(ep, DUMMY_VAR__);
            stan::math::fill(ep,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
            (void) b;  // dummy to suppress unused var warning

            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("pi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi;  // dummy to suppress unused var warning

            stan::math::initialize(pi, DUMMY_VAR__);
            stan::math::fill(pi,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("rho", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
            (void) rho;  // dummy to suppress unused var warning

            stan::math::initialize(rho, DUMMY_VAR__);
            stan::math::fill(rho,DUMMY_VAR__);


            current_statement_begin__ = 48;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 49;
                stan::model::assign(xi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))), 
                            "assigning variable xi");
                current_statement_begin__ = 50;
                stan::model::assign(ep, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))), 
                            "assigning variable ep");
            }
            current_statement_begin__ = 52;
            stan::math::assign(b, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            current_statement_begin__ = 53;
            stan::math::assign(pi, add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            current_statement_begin__ = 54;
            stan::math::assign(rho, stan::math::exp(add(get_base1(mu_pr,5,"mu_pr",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));

            // validate transformed parameters
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"xi",xi,0);
            check_less_or_equal(function__,"xi",xi,1);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"ep",ep,0);
            check_less_or_equal(function__,"ep",ep,1);
            current_statement_begin__ = 44;
            current_statement_begin__ = 45;
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"rho",rho,0);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 114;
            local_scalar_t__ mu_xi;
            (void) mu_xi;  // dummy to suppress unused var warning

            stan::math::initialize(mu_xi, DUMMY_VAR__);
            stan::math::fill(mu_xi,DUMMY_VAR__);
            current_statement_begin__ = 115;
            local_scalar_t__ mu_ep;
            (void) mu_ep;  // dummy to suppress unused var warning

            stan::math::initialize(mu_ep, DUMMY_VAR__);
            stan::math::fill(mu_ep,DUMMY_VAR__);
            current_statement_begin__ = 116;
            local_scalar_t__ mu_b;
            (void) mu_b;  // dummy to suppress unused var warning

            stan::math::initialize(mu_b, DUMMY_VAR__);
            stan::math::fill(mu_b,DUMMY_VAR__);
            current_statement_begin__ = 117;
            local_scalar_t__ mu_pi;
            (void) mu_pi;  // dummy to suppress unused var warning

            stan::math::initialize(mu_pi, DUMMY_VAR__);
            stan::math::fill(mu_pi,DUMMY_VAR__);
            current_statement_begin__ = 118;
            local_scalar_t__ mu_rho;
            (void) mu_rho;  // dummy to suppress unused var warning

            stan::math::initialize(mu_rho, DUMMY_VAR__);
            stan::math::fill(mu_rho,DUMMY_VAR__);
            current_statement_begin__ = 119;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 120;
            validate_non_negative_index("Qgo", "N", N);
            validate_non_negative_index("Qgo", "T", T);
            vector<vector<local_scalar_t__> > Qgo(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(Qgo, DUMMY_VAR__);
            stan::math::fill(Qgo,DUMMY_VAR__);
            current_statement_begin__ = 121;
            validate_non_negative_index("Qnogo", "N", N);
            validate_non_negative_index("Qnogo", "T", T);
            vector<vector<local_scalar_t__> > Qnogo(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(Qnogo, DUMMY_VAR__);
            stan::math::fill(Qnogo,DUMMY_VAR__);
            current_statement_begin__ = 122;
            validate_non_negative_index("Wgo", "N", N);
            validate_non_negative_index("Wgo", "T", T);
            vector<vector<local_scalar_t__> > Wgo(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(Wgo, DUMMY_VAR__);
            stan::math::fill(Wgo,DUMMY_VAR__);
            current_statement_begin__ = 123;
            validate_non_negative_index("Wnogo", "N", N);
            validate_non_negative_index("Wnogo", "T", T);
            vector<vector<local_scalar_t__> > Wnogo(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(Wnogo, DUMMY_VAR__);
            stan::math::fill(Wnogo,DUMMY_VAR__);
            current_statement_begin__ = 124;
            validate_non_negative_index("SV", "N", N);
            validate_non_negative_index("SV", "T", T);
            vector<vector<local_scalar_t__> > SV(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(SV, DUMMY_VAR__);
            stan::math::fill(SV,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 130;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 131;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 132;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 136;
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 137;
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 138;
            stan::math::assign(mu_b, get_base1(mu_pr,3,"mu_pr",1));
            current_statement_begin__ = 139;
            stan::math::assign(mu_pi, get_base1(mu_pr,4,"mu_pr",1));
            current_statement_begin__ = 140;
            stan::math::assign(mu_rho, stan::math::exp(get_base1(mu_pr,5,"mu_pr",1)));

            current_statement_begin__ = 143;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 144;
                validate_non_negative_index("wv_g", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                (void) wv_g;  // dummy to suppress unused var warning

                stan::math::initialize(wv_g, DUMMY_VAR__);
                stan::math::fill(wv_g,DUMMY_VAR__);
                current_statement_begin__ = 145;
                validate_non_negative_index("wv_ng", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                (void) wv_ng;  // dummy to suppress unused var warning

                stan::math::initialize(wv_ng, DUMMY_VAR__);
                stan::math::fill(wv_ng,DUMMY_VAR__);
                current_statement_begin__ = 146;
                validate_non_negative_index("qv_g", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                (void) qv_g;  // dummy to suppress unused var warning

                stan::math::initialize(qv_g, DUMMY_VAR__);
                stan::math::fill(qv_g,DUMMY_VAR__);
                current_statement_begin__ = 147;
                validate_non_negative_index("qv_ng", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                (void) qv_ng;  // dummy to suppress unused var warning

                stan::math::initialize(qv_ng, DUMMY_VAR__);
                stan::math::fill(qv_ng,DUMMY_VAR__);
                current_statement_begin__ = 148;
                validate_non_negative_index("sv", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                (void) sv;  // dummy to suppress unused var warning

                stan::math::initialize(sv, DUMMY_VAR__);
                stan::math::fill(sv,DUMMY_VAR__);
                current_statement_begin__ = 149;
                validate_non_negative_index("pGo", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                (void) pGo;  // dummy to suppress unused var warning

                stan::math::initialize(pGo, DUMMY_VAR__);
                stan::math::fill(pGo,DUMMY_VAR__);


                current_statement_begin__ = 151;
                stan::math::assign(wv_g, initV);
                current_statement_begin__ = 152;
                stan::math::assign(wv_ng, initV);
                current_statement_begin__ = 153;
                stan::math::assign(qv_g, initV);
                current_statement_begin__ = 154;
                stan::math::assign(qv_ng, initV);
                current_statement_begin__ = 155;
                stan::math::assign(sv, initV);
                current_statement_begin__ = 157;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 159;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 160;
                    stan::model::assign(wv_g, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))), 
                                "assigning variable wv_g");
                    current_statement_begin__ = 161;
                    stan::model::assign(wv_ng, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), 
                                "assigning variable wv_ng");
                    current_statement_begin__ = 162;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))), 
                                "assigning variable pGo");

                    current_statement_begin__ = 164;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(pGo, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "pGo") * (1 - get_base1(xi,i,"xi",1))), 
                                "assigning variable pGo");
                    current_statement_begin__ = 165;
                    stan::model::assign(pGo, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(pGo, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "pGo") + (get_base1(xi,i,"xi",1) / 2)), 
                                "assigning variable pGo");
                    current_statement_begin__ = 167;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 170;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 173;
                    stan::model::assign(Qgo, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), 
                                "assigning variable Qgo");
                    current_statement_begin__ = 174;
                    stan::model::assign(Qnogo, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), 
                                "assigning variable Qnogo");
                    current_statement_begin__ = 175;
                    stan::model::assign(Wgo, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), 
                                "assigning variable Wgo");
                    current_statement_begin__ = 176;
                    stan::model::assign(Wnogo, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), 
                                "assigning variable Wnogo");
                    current_statement_begin__ = 177;
                    stan::model::assign(SV, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), 
                                "assigning variable SV");
                    current_statement_begin__ = 180;
                    stan::model::assign(sv, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(sv, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "sv") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))), 
                                "assigning variable sv");
                    current_statement_begin__ = 183;
                    if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                        current_statement_begin__ = 184;
                        stan::model::assign(qv_g, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(qv_g, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "qv_g") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))), 
                                    "assigning variable qv_g");
                    } else {

                        current_statement_begin__ = 186;
                        stan::model::assign(qv_ng, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(qv_ng, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(cue,i,"cue",1),t,"cue",2)), stan::model::nil_index_list()), "qv_ng") + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))), 
                                    "assigning variable qv_ng");
                    }
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 114;
            check_greater_or_equal(function__,"mu_xi",mu_xi,0);
            check_less_or_equal(function__,"mu_xi",mu_xi,1);
            current_statement_begin__ = 115;
            check_greater_or_equal(function__,"mu_ep",mu_ep,0);
            check_less_or_equal(function__,"mu_ep",mu_ep,1);
            current_statement_begin__ = 116;
            current_statement_begin__ = 117;
            current_statement_begin__ = 118;
            check_greater_or_equal(function__,"mu_rho",mu_rho,0);
            current_statement_begin__ = 119;
            current_statement_begin__ = 120;
            current_statement_begin__ = 121;
            current_statement_begin__ = 122;
            current_statement_begin__ = 123;
            current_statement_begin__ = 124;
            current_statement_begin__ = 127;

            // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_rho);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qgo[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qnogo[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wgo[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wnogo[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(SV[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m3";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ep" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ep" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_gng_m3_namespace::model_gng_m3 stan_model;


#endif
