% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{compact}
\alias{compact}
\title{Compact H3 cells}
\usage{
compact(h3_addresses = NULL, simple = TRUE)
}
\arguments{
\item{h3_addresses}{Character vector or list of 15-character indices
generated by H3 at a single resolution, generally the output of
\code{\link[h3jsr:polyfill]{polyfill}}.}

\item{simple}{Logical; whether to return a vector of outputs or a list object
containing both inputs and outputs.}
}
\value{
A list of H3 cells with multiple resolutions. The minimum
  resolution of the output list matches the resolution of the input list.
}
\description{
This function compacts a set of cells of the same resolution into a set of
cells across multiple resolutions that represents the same area.
}
\examples{
\dontrun{
# Give me a compacted representation of County Ashe, NC
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc1 <- nc[1, ]
nc1 <- sf::st_cast(nc1, 'POLYGON')
fillers <- polyfill(geometry = nc1, res = 6)
compacted <- compact(fillers)
}
}
