% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\name{gyrotriangle}
\alias{gyrotriangle}
\title{Gyrotriangle in 3D space}
\usage{
gyrotriangle(
  A,
  B,
  C,
  s = 1,
  iterations = 5,
  palette = NULL,
  bias = 1,
  interpolate = "linear",
  g = identity
)
}
\arguments{
\item{A, B, C}{three distinct 3D points}

\item{s}{positive number, the curvature (the smaller, the more curved)}

\item{iterations}{the gyrotriangle is constructed by iterated subdivisions,
this argument is the number of iterations}

\item{palette}{a vector of colors to decorate the triangle, or \code{NULL}
if you don't want to use a color palette}

\item{bias, interpolate}{if \code{palette} is not \code{NULL}, these
arguments are passed to \code{\link[grDevices]{colorRamp}}}

\item{g}{a function from [0,1] to [0,1]; if \code{palette} is not
\code{NULL}, this function is applied to the scalars defining the colors
(the normalized gyrodistances to the gyrocentroid of the gyrotriangle)}
}
\value{
A \code{\link[rgl]{mesh3d}} object.
}
\description{
3D gyrotriangle as a mesh.
}
\examples{
library(gyro)
library(rgl)
A <- c(1, 0, 0); B <- c(0, 1, 0); C <- c(0, 0, 1)
ABC <- gyrotriangle(A, B, C, s = 0.3)
\donttest{open3d(windowRect = c(50, 50, 562, 562))
view3d(30, 30, zoom = 0.75)
shade3d(ABC, color = "navy", specular = "cyan")}

# using a color palette ####
library(trekcolors)
ABC <- gyrotriangle(
  A, B, C, s = 0.5,
  palette = trek_pal("klingon"), bias = 1.5, interpolate = "spline"
)
\donttest{open3d(windowRect = c(50, 50, 562, 562))
view3d(zoom = 0.75)
shade3d(ABC)}

# hyperbolic icosahedron ####
library(rgl)
library(Rvcg) # to get the edges with the `vcgGetEdge` function
icosahedron <- icosahedron3d() # mesh with 12 vertices, 20 triangles
vertices <- t(icosahedron$vb[-4, ])
triangles <- t(icosahedron$it)
edges <- as.matrix(vcgGetEdge(icosahedron)[, c("vert1", "vert2")])
s <- 0.3
\donttest{open3d(windowRect = c(50, 50, 562, 562))
view3d(zoom = 0.75)
for(i in 1:nrow(triangles)){
  triangle <- triangles[i, ]
  A <- vertices[triangle[1], ]
  B <- vertices[triangle[2], ]
  C <- vertices[triangle[3], ]
  gtriangle <- gyrotriangle(A, B, C, s)
  shade3d(gtriangle, color = "midnightblue")
}
for(i in 1:nrow(edges)){
  edge <- edges[i, ]
  A <- vertices[edge[1], ]
  B <- vertices[edge[2], ]
  gtube <- gyrotube(A, B, s, radius = 0.03)
  shade3d(gtube, color = "lemonchiffon")
}
spheres3d(vertices, radius = 0.05, color = "lemonchiffon")}
}
