% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usgsinst.R
\name{get_usgs_iv_interactively}
\alias{get_usgs_iv_interactively}
\title{Get United States Geologic Survey (USGS) Instantaneous Flow Values Interactively}
\usage{
get_usgs_iv_interactively(
  ns = "usgsiv-ui",
  viewer = shiny::paneViewer(),
  title = "Get USGS Instantaneous Flow Values",
  ...
)
}
\arguments{
\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "Get USGS Instantaneous Flow Values".}

\item{...}{other arguments to \code{leafletOutput()} in module.}
}
\value{
A data.frame that contains flow values based on the station(s) selected
during shiny session.
}
\description{
This function allows the user to select United States Geologic Survey (USGS) stations
and get back instantaneous flow values based on control \verb{number of days from now}. It uses the USGS
Water Services to get the values as well as the USGS Dashboard to get current conditions (circle markers on map).
}
\details{
\strong{Steps}
\enumerate{
\item Select the sites you want to retrieve.
\item Make sure you have the right days.
\item When finished, press 'done' and sites instantaneous flow values will be saved to
a data.frame in local environment.
}
}
\note{
You can select multiple stations but the \verb{number of days from now} control
will take the final number when you select the \code{done} button. The information from the \code{hover} details is not included in
the data.frame that is returned, e.g. rate of change, percentile description.
}
\examples{

if(interactive()){
iv_usgs <- get_usgs_iv_interactively()
}



}
