% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-tbl_custom_summary.R
\name{ratio_summary}
\alias{ratio_summary}
\title{Summarize the ratio of two variables}
\usage{
ratio_summary(numerator, denominator, na.rm = TRUE, conf.level = 0.95)
}
\arguments{
\item{numerator}{String indicating the name of the variable to be summed
for computing the numerator.}

\item{denominator}{String indicating the name of the variable to be summed
for computing the denominator.}

\item{na.rm}{Should missing values be removed before summing the numerator
and the denominator? (default is \code{TRUE})}

\item{conf.level}{Confidence level for the returned confidence interval.
Must be strictly greater than 0 and less than 1. Default to 0.95, which
corresponds to a 95 percent confidence interval.}
}
\description{
\lifecycle{experimental}
This helper, to be used with \code{\link[=tbl_custom_summary]{tbl_custom_summary()}}, creates a function
computing the ratio of two continuous variables and its confidence interval.
}
\details{
Computed statistics:
\itemize{
\item \code{{num}} sum of the variable defined by \code{numerator}
\item \code{{denom}} sum of the variable defined by \code{denominator}
\item \code{{ratio}} ratio of \code{num} by \code{denom}
\item \code{{conf.low}} lower confidence interval
\item \code{{conf.high}} upper confidence interval
}

Confidence interval is computed with \code{\link[stats:poisson.test]{stats::poisson.test()}}, if and only if
\code{num} is an integer.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/ratio_summary_ex1.png" alt="image of rendered example table" style="width:31\%;">
}}
}

\examples{
# Example 1 ----------------------------------
ratio_summary_ex1 <-
  trial \%>\%
  tbl_custom_summary(
    include = c("stage", "grade"),
    by = "trt",
    stat_fns = ~ ratio_summary("response", "ttdeath"),
    statistic = ~ "{ratio} [{conf.low}; {conf.high}] ({num}/{denom})",
    digits = ~ c(3, 2, 2, 0, 0),
    overall_row = TRUE,
    overall_row_label = "All stages & grades"
  ) \%>\%
  bold_labels() \%>\%
  modify_footnote(
    update = all_stat_cols() ~ "Ratio [95\% CI] (n/N)"
  )
}
\seealso{
Other tbl_custom_summary tools: 
\code{\link{add_overall}()},
\code{\link{continuous_summary}()},
\code{\link{proportion_summary}()},
\code{\link{tbl_custom_summary}()}
}
\author{
Joseph Larmarange
}
\concept{tbl_custom_summary tools}
