% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_number.R
\name{style_number}
\alias{style_number}
\title{Style numbers}
\usage{
style_number(
  x,
  digits = 0,
  big.mark = NULL,
  decimal.mark = NULL,
  scale = 1,
  ...
)
}
\arguments{
\item{x}{Numeric vector}

\item{digits}{Integer or vector of integers specifying the number of digits
to round \verb{x=}. When vector is passed, each integer is mapped 1:1 to the
numeric values in \code{x}}

\item{big.mark}{Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{decimal.mark}{The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{scale}{A scaling factor: x will be multiplied by scale before formatting.}

\item{...}{Other arguments passed on to \code{base::format()}}
}
\value{
formatted character vector
}
\description{
Style numbers
}
\examples{
c(0.111, 12.3) \%>\% style_number(digits = 1)
c(0.111, 12.3) \%>\% style_number(digits = c(1, 0))
}
\seealso{
Other style tools: 
\code{\link{style_percent}()},
\code{\link{style_pvalue}()},
\code{\link{style_ratio}()},
\code{\link{style_sigfig}()}
}
\concept{style tools}
