% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_survival.R
\name{tbl_survival.survfit}
\alias{tbl_survival.survfit}
\title{Creates table of survival probabilities}
\usage{
\method{tbl_survival}{survfit}(
  x,
  times = NULL,
  probs = NULL,
  label = ifelse(is.null(probs), "{time}", "{prob*100}\%"),
  level_label = "{level}, N = {n}",
  header_label = NULL,
  header_estimate = NULL,
  failure = FALSE,
  missing = "-",
  estimate_fun = NULL,
  ...
)
}
\arguments{
\item{x}{A survfit object with a no stratification
(e.g. \code{survfit(Surv(ttdeath, death) ~ 1, trial)}), or a single stratifying
variable (e.g. \code{survfit(Surv(ttdeath, death) ~ trt, trial)})}

\item{times}{Numeric vector of times for which to return survival probabilities.}

\item{probs}{Numeric vector of probabilities with values in (0,1)
specifying the survival quantiles to return}

\item{label}{String defining the label shown for the time or prob column.
Default is \code{"{time}"} or \code{"{prob*100}\%"}.  The input uses \link[glue:glue]{glue::glue} notation to
convert the string into a label.  A common label may be \code{"{time} Months"}, which
would resolve to "6 Months" or "12 Months" depending on specified \code{times}.}

\item{level_label}{Used when survival results are stratified.
It is a string defining the label shown.  The input uses
\link[glue:glue]{glue::glue} notation to convert the string into a label.
The default is \code{"{level}, N = {n}"}.  Other information available to
call are \code{'{n}'}, \code{'{level}'}, \code{'{n.event.tot}'}, \code{'{n.event.strata}'}, and
\code{'{strata}'}. See below for details.}

\item{header_label}{String to be displayed as column header.
Default is \code{'**Time**'} when \code{time} is specified, and
\code{'**Quantile**'} when \code{probs} is specified.}

\item{header_estimate}{String to be displayed as column header of the Kaplan-Meier
estimate.  Default is \code{'**Probability**'} when \code{time} is specified, and
\code{'**Time**'} when \code{probs} is specified.}

\item{failure}{Calculate failure probabilities rather than survival probabilities.
Default is \code{FALSE}.  Does NOT apply to survival quantile requests}

\item{missing}{String indicating what to replace missing confidence
limits with in output.  Default is \code{missing = "-"}}

\item{estimate_fun}{Function used to format the estimate and confidence
limits. The default is \code{style_percent(x, symbol = TRUE)} for survival
probabilities, and
\code{style_sigfig(x, digits = 3)} for time estimates.}

\item{...}{Not used}
}
\value{
A \code{tbl_survival} object
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("questioning")}
Please use \link{tbl_survfit}.
Function takes a \code{survfit} object as an argument, and provides a
formatted summary of the results
}
\section{level_label argument}{

The \code{level_label} is used to modify the stratum labels. The default is
\code{level_label = "{level}, N = {n}"}. The quantities in the curly
brackets evaluate to stratum-specific values.  For example, in the trial
data set, there is a column called \code{trt} with levels 'Drug A' and 'Drug B'.
In this example, \code{{level}} would evaluate to either 'Drug A' or 'Drug B'
depending on the stratum.  Other quantities available to print are:
\itemize{
\item \code{{level}} level of the stratification variable
\item \code{{level_label}} label of level for the stratification variable
\item \code{{n}} number of observations, or number within stratum
\item \code{{n.event.tot}} total number of events (total across stratum, if applicable)
\item \code{{n.event.strata}} total number of events within stratum, if applicable
\item \code{{strata}} raw stratum specification from \code{survfit} object
}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_strata_ex1.png}{options: width=40\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_nostrata_ex2.png}{options: width=40\%}}
}

\examples{
library(survival)
fit1 <- survfit(Surv(ttdeath, death) ~ trt, trial)
tbl_strata_ex1 <-
  tbl_survival(
    fit1,
    times = c(12, 24),
    label = "{time} Months"
  )

fit2 <- survfit(Surv(ttdeath, death) ~ 1, trial)
tbl_nostrata_ex2 <-
  tbl_survival(
    fit2,
    probs = c(0.1, 0.2),
    header_estimate = "**Months**"
  )
}
\seealso{
Other tbl_survival tools: 
\code{\link{inline_text.tbl_survival}()},
\code{\link{modify_header}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_survival tools}
\keyword{internal}
