% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_regression.R
\name{tbl_regression}
\alias{tbl_regression}
\title{Display regression model results in table}
\usage{
tbl_regression(x, label = NULL, exponentiate = FALSE, include = NULL,
  exclude = NULL, show_yesno = NULL, conf.level = NULL,
  intercept = FALSE, estimate_fun = NULL, pvalue_fun = NULL)
}
\arguments{
\item{x}{Regression model object}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list("age" ~ "Age, yrs", "ptstage" ~ "Path T Stage")}}

\item{exponentiate}{Logical indicating whether to exponentiate the
coefficient estimates. Default is \code{FALSE}.}

\item{include}{Names of variables to include in output.}

\item{exclude}{Names of variables to exclude from output.}

\item{show_yesno}{By default yes/no categorical variables are printed on a
single row, when the 'No' category is the reference group.  To print both
levels in the output table, include the variable name in the show_yesno
vector, e.g. `show_yesno = c("var1", "var2")``}

\item{conf.level}{Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{intercept}{Logical argument indicating whether to include the intercept
in the output.  Default is \code{FALSE}}

\item{estimate_fun}{Function to round and format coefficient estimates.
Default is \link{style_sigfig} when the coefficients are not transformed, and
\link{style_ratio} when the coefficients have been exponentiated.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}
}
\value{
A \code{tbl_regression} object
}
\description{
This function uses \link[broom:tidy]{broom::tidy} and \link[broom.mixed:tidy]{broom.mixed::tidy}
to perform the initial model formatting. Review the
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html}{tbl_regression vignette}
for detailed examples.
}
\section{Setting Defaults}{

If you prefer to consistently use a different function to format p-values or
estimates, you can set options in the script or in the user- or
project-level startup file, '.Rprofile'.  The default confidence level can
also be set.
\itemize{
\item \code{options(gtsummary.pvalue_fun = new_function)}
\item \code{options(gtsummary.tbl_regression.estimate_fun = new_function)}
\item \code{options(gtsummary.conf.level = 0.90)}
}
}

\section{Note}{

The N reported in the \code{tbl_regression()} output is the number of observations
in the data frame \code{model.frame(x)}. Depending on the model input, this N
may represent different quantities. In most cases, it is the total number of
observations in your model; however, the precise definition of an observation,
or unit of analysis, may differ across models. Here are some common examples.
\enumerate{
\item Survival regression models including time dependent covariates.
\item Random- or mixed-effects regression models with clustered data.
\item GEE regression models with clustered data.
}

This list is not exhaustive, and care should be taken for each number reported.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_regression_ex1.png}{options: width=64\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_regression_ex2.png}{options: width=50\%}}

\if{html}{Example 3}

\if{html}{\figure{tbl_regression_ex3.png}{options: width=50\%}}
}

\examples{
library(survival)
tbl_regression_ex1 <-
  coxph(Surv(ttdeath, death) ~ age + marker, trial) \%>\%
  tbl_regression(exponentiate = TRUE)

tbl_regression_ex2 <-
  glm(response ~ age + grade, trial, family = binomial(link = "logit")) \%>\%
  tbl_regression(exponentiate = TRUE)

library(lme4)
tbl_regression_ex3 <-
  glmer(am ~ hp + (1 | gear), mtcars, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE)
}
\seealso{
See tbl_regression \href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html}{vignette} for detailed examples

Other tbl_regression tools: \code{\link{add_global_p.tbl_regression}},
  \code{\link{add_nevent.tbl_regression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_regression}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{inline_text.tbl_regression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_regression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_stack}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
