% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.R
\name{add_n}
\alias{add_n}
\title{Add column with N}
\usage{
add_n(x, missing = FALSE, last = FALSE)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function}

\item{missing}{Logical argument indicating whether to print N (\code{missing = FALSE}),
or N missing (\code{missing = TRUE}).  Default is \code{FALSE}}

\item{last}{Logical indicator to include N column last in table.
Default is \code{FALSE}, which will display N column first.}
}
\value{
A \code{tbl_summary} object
}
\description{
For each variable in a \code{tbl_summary} table, the \code{add_n} function adds a column with the
total number of non-missing (or missing) observations
}
\section{Example Output}{

\if{html}{\figure{tbl_n_ex.png}{options: width=50\%}}
}

\examples{
tbl_n_ex <-
  trial \%>\%
  dplyr::select(trt, age, grade, response) \%>\%
  tbl_summary(by = trt) \%>\%
  add_n()
}
\seealso{
Other tbl_summary tools: \code{\link{add_overall}},
  \code{\link{add_p}}, \code{\link{add_q.tbl_summary}},
  \code{\link{add_stat_label}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_summary}},
  \code{\link{inline_text.tbl_summary}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_summary}},
  \code{\link{tbl_summary}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
