% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gtfs.R
\name{write_gtfs}
\alias{write_gtfs}
\title{Write GTFS files}
\usage{
write_gtfs(
  gtfs,
  path,
  optional = TRUE,
  extra = TRUE,
  overwrite = TRUE,
  quiet = TRUE,
  warnings = TRUE
)
}
\arguments{
\item{gtfs}{A GTFS object as created by \code{\link{read_gtfs}}.}

\item{path}{The path to the \code{.zip} file in which the feed should be
written to.}

\item{optional}{Whether to write optional \code{.txt}. Defaults to TRUE.}

\item{extra}{Whether to write extra \code{.txt}. Defaults to TRUE.}

\item{overwrite}{Whether to overwrite existing \code{.zip} file. Defaults to
TRUE.}

\item{quiet}{Whether to hide log messages and progress bars (defaults to
TRUE).}

\item{warnings}{Whether to display warning messages (defaults to TRUE).}
}
\value{
Invisibly returns the provided GTFS object with an updated
  \code{validation_result} attribute.
}
\description{
Writes in-memory GTFS objects as GTFS \code{.zip} files. Conditionally
includes optional and extra \code{.txt} files (check
\code{\link{validate_gtfs}} documentation to check what are optional/extra
files).
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

tmp_dir <- file.path(tempdir(), "tmpdir")
dir.create(tmp_dir)
list.files(tmp_dir)

tmp_file <- tempfile(pattern = "gtfs", tmpdir = tmp_dir, fileext = ".zip")
write_gtfs(gtfs, tmp_file)
list.files(tmp_dir)

gtfs_all_files <- read_gtfs(tmp_file)
names(gtfs_all_files)

write_gtfs(gtfs_all_files, tmp_file, optional = FALSE)
gtfs_no_opt <- read_gtfs(tmp_file)
names(gtfs_no_opt)

}
\seealso{
\code{\link{validate_gtfs}}
}
