% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/router.R
\name{gtfs_route}
\alias{gtfs_route}
\title{gtfs_route}
\usage{
gtfs_route(gtfs, from, to, start_time = NULL, day = NULL,
  route_pattern = NULL, earliest_arrival = TRUE, include_ids = FALSE,
  max_transfers = NA, quiet = FALSE)
}
\arguments{
\item{gtfs}{A set of GTFS data returned from \link{extract_gtfs} or, for more
efficient queries, pre-processed with \link{gtfs_timetable}.}

\item{from}{Name of start station}

\item{to}{Name of end station}

\item{start_time}{Desired departure time at \code{from} station, either in seconds
after midnight, a vector of two or three integers (hours, minutes) or (hours,
minutes, seconds), an object of class \link{difftime}, \pkg{hms}, or
\pkg{lubridate}. If not provided, current time is used.}

\item{day}{Day of the week on which to calculate route, either as an
unambiguous string (so "tu" and "th" for Tuesday and Thursday), or a number
between 1 = Sunday and 7 = Saturday. If not given, the current day will be
used. (Not used if \code{gtfs} has already been prepared with
\link{gtfs_timetable}.)}

\item{route_pattern}{Using only those routes matching given pattern, for
example, "^U" for routes starting with "U" (as commonly used for underground
or subway routes. (Parameter not used at all if \code{gtfs} has already been
prepared with \link{gtfs_timetable}.)}

\item{earliest_arrival}{If \code{FALSE}, routing will be with the first-departing
service, which may not provide the earliest arrival at the \code{to} station. This
may nevertheless be useful for bulk queries, as earliest arrival searches
require two routing queries, while earliest departure searches require just
one, and so will be generally twice as fast.}

\item{include_ids}{If \code{TRUE}, result will include columns containing
GTFS-specific identifiers for routes, trips, and stops.}

\item{max_transfers}{If not \code{NA}, specify a maximum number of transfers
(including but not exceeding this number) for the route.}

\item{quiet}{Set to \code{TRUE} to suppress screen messages (currently just
regarding timetable construction).}
}
\value{
square matrix of distances between nodes
}
\description{
Calculate single route between a start and end station departing at or after
a specified time.
}
\note{
This function will by default calculate the route that departs on the
first available service after the specified \code{start_time}, although this may
arrive later than subsequent services. If the earliest arriving route is
desired, ...
}
\examples{
berlin_gtfs_to_zip () # Write sample feed from Berlin, Germany to tempdir
f <- file.path (tempdir (), "vbb.zip") # name of feed
gtfs <- extract_gtfs (f)
from <- "Innsbrucker Platz" # U-bahn station, not "S"
to <- "Alexanderplatz"
start_time <- 12 * 3600 + 120 # 12:02
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time)

# Specify day of week
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday")

# specify travel by "U" = underground only
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday", route_pattern = "^U")
# specify travel by "S" = street-level only (not underground)
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday", route_pattern = "^S")

# Route queries are generally faster if the GTFS data are pre-processed with
# `gtfs_timetable()`:
gt <- gtfs_timetable (gtfs, day = "Sunday", route_pattern = "^S")
route <- gtfs_route (gt, from = from, to = to, start_time = start_time)

}
