% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_gtfs.R
\name{import_gtfs}
\alias{import_gtfs}
\title{Import GTFS transit feeds}
\usage{
import_gtfs(
  path,
  files = NULL,
  fields = NULL,
  extra_spec = NULL,
  skip = NULL,
  quiet = TRUE
)
}
\arguments{
\item{path}{A string. The path to a GTFS \code{.zip} file.}

\item{files}{A character vector. The text files to be read from the GTFS,
without the \code{.txt} extension. If \code{NULL} (the default), all
existing text files are read.}

\item{fields}{A named list. The fields to be read from each text file, in the
format \code{list(file1 = c("field1", "field2"))}. If \code{NULL} (the
default), all fields from the files specified in \code{files} are read. If
a file is specified in \code{files} but not in \code{fields}, all fields
from that file will be read (i.e. you may specify in \code{fields} only
files whose fields you want to subset).}

\item{extra_spec}{A named list. Custom specification used when reading
undocumented fields, in the format
\code{list(file1 = c(field1 = "type1", field2 = "type2"))}. If \code{NULL}
(the default), all undocumented fields are read as character. Similarly,
if an undocumented field is not specified in \code{extra_spec}, it is read
as character (i.e. you may specify in \code{extra_spec} only the fields
that you want to read as a different type). Only supports the
\code{character}, \code{integer} and \code{numeric} types, also used in
\code{\link{get_gtfs_standards}}.}

\item{skip}{A character vector. Text files that should not be read from the
GTFS, without the \code{.txt} extension. If \code{NULL} (the default), no
files are skipped. Cannot be used if \code{files} is set.}

\item{quiet}{A logical. Whether to hide log messages and progress bars
(defaults to \code{TRUE}).}
}
\value{
A GTFS object: a named list of data frames, each one corresponding to
  a distinct text file from the given GTFS feed.
}
\description{
Imports GTFS transit feeds from either a local \code{.zip} file or an URL.
Columns are parsed according to the standards for reading and writing GTFS
feeds specified in \code{\link{get_gtfs_standards}}.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")

# read all files and columns
gtfs <- import_gtfs(gtfs_path)
names(gtfs)
names(gtfs$trips)

# read all columns from selected files
gtfs <- import_gtfs(gtfs_path, files = c("trips", "stops"))
names(gtfs)
names(gtfs$trips)

# read specific columns from selected files
gtfs <- import_gtfs(
  gtfs_path,
  files = c("trips", "stops"),
  fields = list(
    trips = c("route_id", "trip_id"),
    stops = c("stop_id", "stop_lat", "stop_lon")
  )
)

}
\seealso{
\code{\link{get_gtfs_standards}}

Other io functions: 
\code{\link{export_gtfs}()}
}
\concept{io functions}
