% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps_as_sfpoints.R
\name{gps_as_sfpoints}
\alias{gps_as_sfpoints}
\title{Convert GPS-like data.table to a Simple Feature points object}
\usage{
gps_as_sfpoints(gps, crs = 4326)
}
\arguments{
\item{gps}{A data.table with timestamp data.}

\item{crs}{A Coordinate Reference System. The default value is 4326 (latlong WGS84).}
}
\value{
A simple feature (sf) object with point data.
}
\description{
Convert a GPS data stored in a data.table into Simple Feature points.
}
\examples{
library(gtfs2gps)
library(dplyr)

fortaleza <- read_gtfs(system.file("extdata/fortaleza.zip", package = "gtfs2gps"))
srtmfile <- system.file("extdata/fortaleza-srtm.tif", package="gtfs2gps")

subset <- fortaleza \%>\%
  filter_week_days() \%>\%
  filter_single_trip() \%>\%
  filter_by_shape_id("shape806-I")

for_gps <- gtfs2gps(subset)
for_gps_sf_points <- gps_as_sfpoints(for_gps)
}
