% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_pad_num.R
\name{fmt_pad_num}
\alias{fmt_pad_num}
\title{Format numeric columns to align at decimal point without trailing zeroes}
\usage{
fmt_pad_num(gt_object, columns, nsmall = 2, gfont = "Fira Mono")
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns to format. Can either be a series of column names provided in \code{c()}, a vector of column indices, or a helper function focused on selections. The select helper functions are: \code{starts_with()}, \code{ends_with()}, \code{contains()}, \code{matches()}, \code{one_of()}, \code{num_range()}, and \code{everything()}.}

\item{nsmall}{The max number of decimal places to round at/display}

\item{gfont}{The complete name of a font available in Google Fonts. For the \code{fmt_pad_num} function this requires a monospaced font, where Google has many available at \href{https://fonts.google.com/?category=Monospace&preview.text=1234567890&preview.text_type=custom}{fonts.google.com}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
This function removes repeating trailing zeroes and adds blank white space
to align at the decimal point. This requires the use of true monospaced fonts,
which are supplied via the \code{gt::google_font()} function. This is a wrapper
around \code{gt::fmt()} and \code{gtExtras::pad_fn()}.
}
\section{Figures}{

\if{html}{\figure{fmt_pad_num.png}{options: width=20\%}}
}

\section{Function ID}{

2-2
}

\examples{
library(gt)
padded_tab <- data.frame(numbers = c(1.2345, 12.345, 123.45, 1234.5, 12345)) \%>\%
  gt() \%>\%
  fmt_pad_num(columns = numbers, nsmall = 4)
}
\seealso{
\code{\link[=pad_fn]{pad_fn()}}

Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
