% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_separations}
\alias{plot_separations}
\title{Plot Optimal Transport local separations}
\usage{
plot_separations(x, ranking = NULL, wb_all = FALSE, ...)
}
\arguments{
\item{x}{An object generated by \code{\link{ot_indices}},
\code{\link{ot_indices_1d}}, or \code{\link{ot_indices_wb}}.}

\item{ranking}{An integer with absolute value less or equal than the number
of inputs. If positive, select the first \code{ranking} inputs per importance.
If negative, select the last \code{ranking} inputs per importance.}

\item{wb_all}{(default \code{FALSE}) Logical that defines whether or not to plot
the Advective and Diffusive components of the Wasserstein-Bures indices.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A \code{patchwork} object that, if called, will print.
}
\description{
Plot Optimal Transport based local separations for each partition using
\code{ggplot2} package. If provided, it plots also the uncertainty estimates.
}
\examples{
N <- 1000

mx <- c(1, 1, 1)
Sigmax <- matrix(data = c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), nrow = 3)

x1 <- rnorm(N)
x2 <- rnorm(N)
x3 <- rnorm(N)

x <- cbind(x1, x2, x3)
x <- mx + x \%*\% chol(Sigmax)

A <- matrix(data = c(4, -2, 1, 2, 5, -1), nrow = 2, byrow = TRUE)
y <- t(A \%*\% t(x))

x <- data.frame(x)

M <- 25

# Get sensitivity indices
sensitivity_indices <- ot_indices(x, y, M)
plot_separations(sensitivity_indices)

}
