% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgps.R
\name{generate_causal_survival_data}
\alias{generate_causal_survival_data}
\title{Simulate causal survival data}
\usage{
generate_causal_survival_data(
  n,
  p,
  Y.max = NULL,
  y0 = NULL,
  X = NULL,
  rho = 0,
  n.mc = 10000,
  dgp = c("simple1", "type1", "type2", "type3", "type4", "type5")
)
}
\arguments{
\item{n}{The number of samples.}

\item{p}{The number of covariates.}

\item{Y.max}{The maximum follow-up time (optional).}

\item{y0}{Query time to estimate P(T(1) > y0 | X) - P(T(0) > y0 | X) (optional).}

\item{X}{The covariates (optional).}

\item{rho}{The correlation coefficient of the X's covariance matrix V_{ij} = rho^|i-j|. Default is 0.}

\item{n.mc}{The number of monte carlo draws to estimate the treatment effect with. Default is 10000.}

\item{dgp}{The type of DGP.}
}
\value{
A list with entries:
 `X`: the covariates, `Y`: the event times, `W`: the treatment indicator, `D`: the censoring indicator,
 `cate`: the treatment effect (RMST) estimated by monte carlo, `cate.prob` the difference in survival probability,
 `cate.sign`: the true sign of the cate for ITR comparison, `dgp`: the dgp name, `Y.max`: the maximum follow-up time,
 `y0`: the query time for difference in survival probability.
}
\description{
The following DGPs are available for benchmarking purposes, T is the failure time
and C the censoring time:
\itemize{
  \item "simple1": T = X1*eps + W, C ~ U(0, 2) where eps ~ Exp(1) and Y.max = 1.
  \item  "type1": T is drawn from an accelerated failure time model and C from a Cox model (scenario 1 in https://arxiv.org/abs/2001.09887)
  \item  "type2": T is drawn from a proportional hazard model and C from a accelerated failure time (scenario 2 in https://arxiv.org/abs/2001.09887)
  \item  "type3": T and C are drawn from a Poisson distribution  (scenario 3 in https://arxiv.org/abs/2001.09887)
  \item  "type4": T and C are drawn from a Poisson distribution  (scenario 4 in https://arxiv.org/abs/2001.09887)
  \item  "type5": is similar to "type2" but with censoring generated from an accelerated failure time model.
}
}
\examples{
\donttest{
# Generate data
n <- 1000
p <- 5
data <- generate_causal_survival_data(n, p)
# Get true CATE on a test set
X.test <- matrix(seq(0, 1, length.out = 5), 5, p)
cate.test <- generate_causal_survival_data(n, p, X = X.test)$cate
}

}
