% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scores.R
\name{get_scores.instrumental_forest}
\alias{get_scores.instrumental_forest}
\title{Doubly robust scores for estimating the average conditional local average treatment effect.}
\usage{
\method{get_scores}{instrumental_forest}(
  forest,
  subset = NULL,
  debiasing.weights = NULL,
  compliance.score = NULL,
  num.trees.for.weights = 500,
  ...
)
}
\arguments{
\item{forest}{A trained instrumental forest.}

\item{subset}{Specifies subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the treatment Wi or the outcome Yi.}

\item{debiasing.weights}{A vector of length n (or the subset length) of debiasing weights.
If NULL (default) these are obtained via the appropriate doubly robust score
construction, e.g., in the case of causal_forests with a binary treatment, they
are obtained via inverse-propensity weighting.}

\item{compliance.score}{An estimate of the causal effect of Z on W, i.e., Delta(X) = E[W | X, Z = 1]
- E[W | X, Z = 0], which can then be used to produce debiasing.weights. If not provided,
this is estimated via an auxiliary causal forest.}

\item{num.trees.for.weights}{In some cases (e.g., with causal forests with a continuous
treatment), we need to train auxiliary forests to learn debiasing weights.
This is the number of trees used for this task. Note: this argument is only
used when debiasing.weights = NULL.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of scores.
}
\description{
Given an outcome Y, treatment W and instrument Z, the (conditional) local
average treatment effect is tau(x) = Cov[Y, Z | X = x] / Cov[W, Z | X = x].
This is the quantity that is estimated with an instrumental forest.
It can be intepreted causally in various ways. Given a homogeneity
assumption, tau(x) is simply the CATE at x. When W is binary
and there are no "defiers", Imbens and Angrist (1994) show that tau(x) can
be interpreted as an average treatment effect on compliers. This doubly robust
scores provided here are for estimating tau = E[tau(X)].
}
\references{
Aronow, Peter M., and Allison Carnegie. "Beyond LATE: Estimation of the
             average treatment effect with an instrumental variable." Political
             Analysis 21(4), 2013.

Chernozhukov, Victor, Juan Carlos Escanciano, Hidehiko Ichimura,
            Whitney K. Newey, and James M. Robins. "Locally robust semiparametric
            estimation." arXiv preprint arXiv:1608.00033, 2016.

Imbens, Guido W., and Joshua D. Angrist. "Identification and Estimation of
            Local Average Treatment Effects." Econometrica 62(2), 1994.
}
