% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_diagnost.R
\name{diagnost}
\alias{diagnost}
\alias{diagnost.HRMnetwork}
\title{Diagnostic tool for generated sample}
\usage{
diagnost(obj, ...)

\method{diagnost}{HRMnetwork}(obj, X, id, y, ...)
}
\arguments{
\item{obj}{Object of class \code{HRMtree}}

\item{...}{additional arguments}

\item{X}{A matrix of data to be diagnosted}

\item{id}{The name of the variable for which the diagnostics is done.}

\item{y}{bivariate vector with elements between 0 and 1. The coordinates of the bivariate copula.}
}
\value{
No return value
}
\description{
Performs diagnosis on the generated data according to a graphical model on a tree
with cliquewise Huesler-Reiss distributions. As one diagnostic tool, the function produces a graph comparing
the real marginal distribution
with the empirical distribution of the variable in \code{id}. As a second diagnostic tool
for every adjacent node to \code{id} it computes the real and the empirical copulas at the coordinates
passed to \code{y}.
}
\examples{
# create a graph with named vertices
g<- graph(c("a", "b", "b","c", "b", "d"), directed = FALSE)
# create a HRMtree object
myobj<- HRMtree(g)
x<- c(0.1,0.2,0.3)
myobj<- setParams(myobj, x)
# create a dataset
mydata<- rHRM(myobj, 1000)
# do diagnostic on the node "b"
diagnost(myobj, mydata, "b", y = c(0.2,0.5) )
# include noise in the data
mydata<- rHRM(myobj, 1000, noise = TRUE)
diagnost(myobj, mydata, "c", y = c(0.5,0.5))
}
