% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_greek.R
\name{print.summary_greek}
\alias{print.summary_greek}
\title{Print Summary for Linear Model Fits With Greek Letters}
\usage{
\method{print}{summary_greek}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"),
  concise = FALSE,
  ...
)
}
\arguments{
\item{x}{an object used to select a method.}

\item{digits}{minimal number of \emph{significant} digits, see
    \code{\link[base]{print.default}}.}

\item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in
    a symbolic form (see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}

\item{concise}{logical.}

\item{...}{
  Arguments passed on to \code{\link[base:print]{base::print}}, \code{\link[stats:summary.lm]{stats::summary.lm}}
  \describe{
    \item{\code{object}}{an object of class \code{"lm"}, usually, a result of a
    call to \code{\link[stats]{lm}}.}
    \item{\code{correlation}}{logical; if \code{TRUE}, the correlation matrix of
    the estimated parameters is returned and printed.}
  }}
}
\value{
The function is like print.summary.lm but with Greek
letters in output.
}
\description{
print summary method with Greek letters for class "lm".
}
\details{
It is recommended that the font size of the R console be increased for
better visualization of the symbols,
as some of the symbols are quite small.
}
\examples{

\dontrun{
#Same example as summary.lm and print.summary.lm from stat packages but with Greek letters.
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1) # omitting intercept
coef(lm.D90)  # the bare coefficients
sld90 <- greekLetters::summary_greek(lm.D90 <- lm(weight ~ group -1))  # omitting intercept
greekLetters::print.summary_greek(sld90)
}

}
\seealso{
See \code{\link[stats]{summary.lm}} for more details.
}
\author{
Kévin Allan Sales Rodrigues.
}
