% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Simple projections of the annual 2\% samples of Australian Taxation Office tax returns.}
\usage{
project(
  sample_file,
  h = 0L,
  fy.year.of.sample.file = NULL,
  WEIGHT = 50L,
  excl_vars = NULL,
  forecast.dots = list(estimator = "mean", pred_interval = 80),
  wage.series = NULL,
  lf.series = NULL,
  use_age_pop_forecast = FALSE,
  .recalculate.inflators = NA,
  .copyDT = TRUE,
  check_fy_sample_file = TRUE,
  differentially_uprate_Sw = NA,
  r_super_balance = 1.05
)
}
\arguments{
\item{sample_file}{A \code{data.table} matching a 2\% sample file from the ATO.
See package \code{taxstats} for an example.}

\item{h}{An integer. How many years should the sample file be projected?}

\item{fy.year.of.sample.file}{The financial year of \code{sample_file}. If \code{NULL}, the default, the number is inferred from the 
number of rows of \code{sample_file} to be one of \code{2012-13}, \code{2013-14}, \code{2014-15}, \code{2015-16}, or \code{2016-17}.}

\item{WEIGHT}{The sample weight for the sample file. (So a 2\% file has \code{WEIGHT} = 50.)}

\item{excl_vars}{A character vector of column names in \code{sample_file} that should not be inflated. Columns not present in the 2013-14 sample file are not inflated and nor are the columns \code{Ind}, \code{Gender}, \code{age_range}, \code{Occ_code}, \code{Partner_status}, \code{Region}, \code{Lodgment_method}, and \code{PHI_Ind}.}

\item{forecast.dots}{A list containing parameters to be passed to \code{generic_inflator}.}

\item{wage.series}{See \code{\link{wage_inflator}}. Note that the \code{Sw_amt}
will uprated by \code{\link{differentially_uprate_wage}} (if requested).}

\item{lf.series}{See \code{\link{lf_inflator_fy}}.}

\item{use_age_pop_forecast}{Should the inflation of the number of taxpayers be 
moderated by the number of resident persons born in a certain year? If \code{TRUE},
younger ages will grow at a slightly higher rate beyond 2018 than older ages.}

\item{.recalculate.inflators}{(logical, default: \code{NA}). 
Should \code{generic_inflator()} or \code{CG_inflator} be called to project the other variables? Adds time.
Default \code{NA} means \code{TRUE} if the pre-calculated inflators are available,
\code{FALSE} otherwise.}

\item{.copyDT}{(logical, default: \code{TRUE}) Should a \code{copy()} of \code{sample_file} be made?
If set to \code{FALSE}, will update \code{sample_file} in place, which may
be necessary when memory is constrained, but is dangerous as it modifies the
original data and its projection. (So if you run the same code twice you 
may end up with a projection \code{2h} years ahead, not \code{h} years.)}

\item{check_fy_sample_file}{(logical, default: \code{TRUE}) 
Should \code{fy.year.of.sample.file} be checked against \code{sample_file}?
By default, \code{TRUE}, an error is raised if the base is not 2012-13, 2013-14, 2014-15, 2015-16, 2016-17,
or 2017-18,
 and a warning is raised if the 
number of rows in \code{sample_file} is different to the known number of rows in the sample files.}

\item{differentially_uprate_Sw}{(logical, default: \code{NA}) 
Should the salary and wage column (\code{Sw_amt}) be differentially uprated 
using (\code{\link{differentially_uprate_wage}})? Default of \code{NA} means
use differential uprating is used when \code{fy.year.of.sample.file <= "2016-17"}.
It is known that the Treasury stopped using differential uprating by 2019.

Selecting \code{TRUE} for \code{fy.year.of.sample.file > "2016-17"} is an 
error as the precalculated values are not available.}

\item{r_super_balance}{The factor to inflate super balances by (annualized).
Set to \code{1.05} for backwards compatibility. The annual superannuation 
bulletin of June 2019 from APRA reported 7.3\% growth of funds with more than
fund members over the previous 5 years and 7.9\% growth over the 
previous ten years.}
}
\value{
A sample file with the same number of rows as \code{sample_file} but 
with inflated values as a forecast for the sample file in \code{to_fy}. 
If \code{WEIGHT} is not already a column of \code{sample_file}, it will be added and its sum
will be the predicted number of taxpayers in \code{to_fy}.
}
\description{
Simple projections of the annual 2\% samples of Australian Taxation Office tax returns.
}
\details{
Currently components of taxable income are individually inflated 
based on their historical trends in the ATO sample files, with the 
exception of:
\describe{
\item{inflated using \code{\link{differentially_uprate_wage}}.}{\code{Sw_amt}}
\item{inflated using \code{\link{wage_inflator}}}{\code{Alow_ben_amt}, \code{ETP_txbl_amt}, \code{Rptbl_Empr_spr_cont_amt}, \code{Non_emp_spr_amt}, \code{MCS_Emplr_Contr}, \code{MCS_Prsnl_Contr}, \code{MCS_Othr_Contr}}
\item{inflated using \code{\link{cpi_inflator}}}{\code{WRE_car_amt}, \code{WRE_trvl_amt}, \code{WRE_uniform_amt}, \code{WRE_self_amt}, \code{WRE_other_amt}}
\item{inflated by \code{\link{lf_inflator_fy}}}{\code{WEIGHT}}
\item{inflated by \code{\link{CG_inflator}}}{\code{Net_CG_amt}, \code{Tot_CY_CG_amt}}
}

Superannuation balances are inflated by a fixed rate of 5\% p.a.

We recommend you use \code{sample_file_1213} over \code{sample_file_1314},
unless you need the superannuation variables, 
as the latter suggests lower-than-recorded tax collections. 
However, more recent data is of course preferable.
}
