% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aus_pop_qtr_age.R
\name{aus_pop_qtr_age}
\alias{aus_pop_qtr_age}
\title{Australian estimated resident population by age and date}
\usage{
aus_pop_qtr_age(date = NULL, age = NULL, tbl = FALSE, roll = TRUE,
  roll.beyond = FALSE)
}
\arguments{
\item{date}{A vector of dates. If \code{NULL}, values for all dates are returned in a table. The dates need not be quarters, provided \code{roll != FALSE},}

\item{age}{A vector of (integer) ages from 0 to 100 inclusive. If \code{NULL}, all ages are returned.}

\item{tbl}{Should a table be returned? If \code{FALSE}, a vector is returned.}

\item{roll}{Should a rolling join be performed?}

\item{roll.beyond}{Should inputs be allowed to go beyond the limits of data (without a warning)?
This is passed to \code{data.table}'s join, so options other than \code{TRUE} and \code{FALSE} are available. 
See \code{?data.table}.}
}
\value{
A \code{data.table} or \code{vector} with values of the estimated resident population.
}
\description{
Australian estimated resident population by age and date
}
\examples{
aus_pop_qtr_age(date = as.Date("2016-01-01"), age = 42)
}
