% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_grouper.R
\name{age_grouper}
\alias{age_grouper}
\title{Age grouper}
\usage{
age_grouper(age, interval = 10, min_age = 25, max_age = 75,
  breaks = NULL, labels = NULL, below = "Below\\n",
  exp_min_age = 1L, exp_max_age = 100L, threshold = 10000L)
}
\arguments{
\item{age}{A numeric age (in years).}

\item{interval}{How big should the age range be. 25-34 means interval = 10.}

\item{min_age}{What is the upper bound of the lowest bracket? (\code{min_age = 25} means 'Under 25' will be the lowest bracket.)}

\item{max_age}{What is the lower bound of the highest bracket? (\code{max_age = 75} means '75+' will be the bracket.)}

\item{breaks}{Specify breaks manually.}

\item{labels}{Specify the labels manually.}

\item{below}{String giving the prefix for the lowest bin. (Only applicable
if \code{breaks} and \code{labels} are \code{NULL}.)}

\item{exp_min_age, exp_max_age}{Integers specifying the lowest/highest expected 
age in \code{age}. If any values fall outside this range, ages will still work
though perhaps slow when \code{length(age) >> threshold}.}

\item{threshold}{An integer, the minimum length at which the calculation will
be accelerated.}
}
\value{
An ordered factor giving age ranges (separated by hyphens) as specified.
}
\description{
Age grouper
}
\examples{
age_grouper(42)
age_grouper(42, interval = 5, min_age = 20, max_age = 60)
}
