% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-sim.R
\name{data_sim}
\alias{data_sim}
\title{Simulate example data for fitting GAMs}
\usage{
data_sim(
  model = "eg1",
  n = 400,
  scale = 2,
  dist = c("normal", "poisson", "binary"),
  seed = NULL
)
}
\arguments{
\item{model}{character; either \code{"egX"} where \code{X} is an integer \code{1:7}, or
the name of a model. See Details for possible options.}

\item{n}{numeric; the number of observations to simulate.}

\item{scale}{numeric; the level of noise to use.}

\item{dist}{character; a sampling distribution for the response
variable.}

\item{seed}{numeric; the seed for the random number generator. Passed to
\code{\link[base:set.seed]{base::set.seed()}}.}
}
\description{
A tidy reimplementation of the functions implemented in \code{\link[mgcv:gamSim]{mgcv::gamSim()}}
that can be used to fit GAMs. An new feature is that the sampling
distribution can be applied to all the example types.
}
\examples{
\dontshow{
set.seed(1)
op <- options(digits = 5, cli.unicode = FALSE)
}
data_sim("eg1")
\dontshow{options(op)}
}
