% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen-methods.R
\name{datagen}
\alias{datagen}
\alias{datagen.mgcv.smooth}
\alias{datagen.fs.interaction}
\alias{datagen.gam}
\alias{datagen.gamm}
\title{Generate data over the range of variables used in smooths}
\usage{
datagen(x, ...)

\method{datagen}{mgcv.smooth}(x, n = 100, data, ...)

\method{datagen}{fs.interaction}(x, n = 100, data, ...)

\method{datagen}{gam}(x, n = 200, ...)

\method{datagen}{gamm}(x, ...)
}
\arguments{
\item{x}{an object for which new data is required. Currently objects of classes \code{"gam"}, and \code{"gamm"} are supported, as are smooths from \strong{mgcv} inheriting from class \code{"mgcv.smooth"}.}

\item{...}{arguments passed to methods}

\item{n}{numeric; the number of data values to generate per term in each smooth.}

\item{data}{data frame; for \code{"mgcv.smooth"} objects, the data used to fit the GAM need to be supplied.}
}
\value{
A data frame of new values spread over the range of the observed values.
}
\description{
For each smooth in a GAM, generate new data over the range of the variables in volved in a smooth.
}
\examples{
load_mgcv()

## 1d example
set.seed(2)
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")
df <- datagen(m1)
head(df)

## 2d example
dat <- gamSim(2, n = 400, dist = "normal", scale = 2)
m2 <- gam(y ~ s(x, z), data = dat$data, method = "REML")
df <- datagen(m2)
head(df)
## alternative showing using the mgcv.smooth method for a single smooth
df2 <- datagen(m2[["smooth"]][[1L]], data = dat$data)
head(df2)
}
\author{
Gavin L. Simpson
}
