% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_yrwk.R
\name{as_yrwk}
\alias{as_yrwk}
\alias{as_yrwk.default}
\alias{as_yrwk.yrwk}
\alias{as_yrwk.Date}
\alias{as_yrwk.POSIXt}
\alias{as_yrwk.character}
\alias{as_yrwk.factor}
\title{Convert an object to a yrwk}
\usage{
as_yrwk(x, firstday = 1L, ...)

\method{as_yrwk}{default}(x, firstday = 1L, ...)

\method{as_yrwk}{yrwk}(x, ...)

\method{as_yrwk}{Date}(x, firstday = 1L, ...)

\method{as_yrwk}{POSIXt}(x, firstday = 1L, ...)

\method{as_yrwk}{character}(x, firstday = 1L, ...)

\method{as_yrwk}{factor}(x, firstday = 1L, ...)
}
\arguments{
\item{x}{`An object to coerce to yrwk.}

\item{firstday}{An integer representing the day the week starts on from 1
(Monday) to 7 (Sunday).}

\item{...}{Not used.}
}
\value{
A \code{yrwk} object.
}
\description{
\itemize{
\item Date, POSIXct, and POSIXlt are converted directly.  Any day, hour, minute,
or second components are dropped. POSIXct and POSIXlt are converted to
dates via \code{as.date()} with the timezone respected.
\item Character input is assumed to be provided in either ISO 8601 standard
format, i.e. "yyyy-mm-dd", or yrwk format, i.e. "yyyy-Www". On conversion
the day component will be dropped.
}
}
\note{
Internally \code{yrwk} objects are stored as the number of weeks from the
date of the \code{firstday} nearest the Unix Epoch (1970-01-01).  That is:\preformatted{- 1969-12-29 for `firstday` as Monday
- 1969-12-30 for `firstday` as Tuesday
- 1969-12-31 for `firstday` as Wednesday
- 1970-01-01 for `firstday` as Thursday
- 1970-01-02 for `firstday` as Friday
- 1970-01-03 for `firstday` as Saturday
- 1970-01-04 for `firstday` as Sunday
}
}
\examples{
as_yrwk(Sys.Date())
as_yrwk(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_yrwk("2019-05-03")
as_yrwk("2021-W03")

}
