% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmodel.P.R
\name{gmodel.P}
\alias{gmodel.P}
\title{Generate graphs given a probability matrix}
\usage{
gmodel.P(P, rep = 1, noloop = TRUE, symmetric.out = FALSE)
}
\arguments{
\item{P}{an \code{(n-by-n)} probability matrix.}

\item{rep}{the number of observations to be generated.}

\item{noloop}{a logical value; TRUE for graphs without self-loops, FALSE otherwise.}

\item{symmetric.out}{a logical value; FALSE for generated graphs to be nonsymmetric, TRUE otherwise. Note that
TRUE is supported only if the input matrix P is symmetric.}
}
\value{
depending on \code{rep} value, either
\describe{
\item{(rep=1)}{an \code{(n-by-n)} observation matrix, or}
\item{(rep>1)}{a length-\code{rep} list where each element
is an observation is an \code{(n-by-n)} realization from the model.}
}
}
\description{
Given an (n-by-n) probability matrix P, \code{gmodel.P} generates
binary observation graphs corresponding to Bernoulli distribution
whose parameter matches to the element of P.
}
\examples{
## set inputs
modelP <- matrix(runif(16),nrow=4)

## generate 3 observations without self-loops.
out <- gmodel.P(modelP,rep=3,noloop=TRUE)

## Visualize generated graphs
par(mfrow=c(1,3))
image(out[[1]])
image(out[[2]])
image(out[[3]])

}
