% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_anova_slopes.R
\name{mixed_anova_slopes}
\alias{mixed_anova_slopes}
\title{ANOVA table from linear mixed effects analysis.}
\usage{
mixed_anova_slopes(
  data,
  Y_value,
  Fixed_Factor,
  Slopes_Factor,
  Random_Factor,
  Df_method = "Kenward-Roger",
  SS_method = "II",
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{Y_value}{name of column containing quantitative (dependent) variable, provided within "quotes".}

\item{Fixed_Factor}{name(s) of categorical fixed factors (independent variables) provided as a vector if more than one or within "quotes".}

\item{Slopes_Factor}{name of factor to allow varying slopes on.}

\item{Random_Factor}{name(s) of random factors to allow random intercepts; to be provided as a vector when more than one or within "quotes".}

\item{Df_method}{method for calculating degrees of freedom. Default is Kenward-Roger, can be changed to "Satterthwaite".}

\item{SS_method}{type of sum of square, default is type II, can be changed to "I", "III", "1" or "2", or others.}

\item{...}{any additional arguments to pass on to \code{\link[lme4]{lmer}} if required.}
}
\value{
ANOVA table of class "anova" and "data.frame".
}
\description{
There are four related functions for mixed effects analyses: \code{mixed_model}, \code{mixed_anova}, \code{mixed_model_slopes}, and \code{mixed_anova_slopes}.
}
\details{
This function uses \code{\link[lme4]{lmer}} to fit a linear mixed effect model and provides the model object, which could be used for post-hoc comparisons. The model object is converted to class \code{lmerModLmerTest} object by \code{\link[lmerTest]{as_lmerModLmerTest}}.

It produces a type II sum of squares ANOVA table with Kenward-Roger approximation for degrees of freedom (as implemented in \code{lmerTest}) package.
It requires a data table, one dependent variable (Y_value), one or more independent variables (Fixed_Factor). Exactly one random factor (Random_Factor) and Slope_Factor should be provided.
This function is related to \code{\link{mixed_model}}.

More than one fixed factors can be provided as a vector (e.g. c("A", "B")). A full model with interaction term is fitted with one term each for varying slopes and intercepts.
This means when \code{Y_value = Y, Fixed_factor = c("A", "B"), Slopes_Factor = "S", Random_factor = "R"} are entered as arguments, these are passed on as \code{Y ~ A*B + (S|R)} (which is equivalent to \code{Y ~ A + B + A:B + (S|R)}).
In this experimental implementation, random slopes and intercepts are fitted (\code{(Slopes_Factor|Random_Factor)}). Only one term each is allowed for ¬ and \code{Random_Factor}.
}
\examples{
mixed_anova_slopes(data = data_2w_Tdeath,
Y_value = "PI",
Fixed_Factor = c("Genotype", "Time"),
Slopes_Factor = "Time",
Random_Factor = "Experiment")

}
