% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterbox_sc.R
\name{plot_scatterbox_sc}
\alias{plot_scatterbox_sc}
\title{Plot a scatter plot on a boxplot with two variables.}
\usage{
plot_scatterbox_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  symsize = 2.5,
  symthick = 1,
  jitter = 0,
  b_alpha = 1,
  s_alpha = 1,
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{symsize}{size of symbols used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of symbol border (\code{stroke} parameter of \code{geom_point}), default set to 1.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0 (i.e. aligned symbols). To reduce symbol overlap, try 0.1-0.3 or higher.}

\item{b_alpha}{fractional opacity of boxplot, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_scatterbox_sd}, but this one maps a single or same colour, therefore \verb{_sc}.
The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{
#with jitter
plot_scatterbox_sc(data = data_cholesterol, 
xcol = Treatment, ycol = Cholesterol, jitter = 0.1)
#with "ok_grey" colour
plot_scatterbox_sc(data = data_cholesterol, 
xcol = Treatment, ycol = Cholesterol, 
colour = "ok_grey", jitter = 0.1)
}
