% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg_bbox.R
\name{gpkg_bbox}
\alias{gpkg_bbox}
\title{Get Bounding Box of a GeoPackage Layer}
\usage{
gpkg_bbox(x, table_name, geom_column = "geom")
}
\arguments{
\item{x}{A \emph{geopackage} object}

\item{table_name}{character. One or more table names.}

\item{geom_column}{character. Geometry column name, default \code{"geom"}}
}
\value{
a \emph{data.frame} containing columns \code{"xmin"}, \code{"ymin"}, \code{"xmax"}, \code{"ymax"}
}
\description{
This function applies an OGR SQL query to obtain bounding coordinates of a table containing a geometry column. \url{https://gdal.org/user/sql_sqlite_dialect.html} and \url{https://gdal.org/user/ogr_sql_dialect.html}
}
\examples{
\dontshow{if (!inherits(try(requireNamespace("terra", quietly=TRUE), silent=TRUE), 'try-error')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
tf <- tempfile(fileext = ".gpkg")

r <- terra::rast(system.file("extdata", "dem.tif", package = "gpkg"))
v <- as.polygons(r, ext = TRUE)
g <- geopackage(list(bbox = v))

gpkg_bbox(g, 'bbox')
}
\dontshow{\}) # examplesIf}
}
\keyword{internal}
