% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branding.R
\name{theme_brand}
\alias{theme_brand}
\title{Generate ggplot2 theme from brand configuration}
\usage{
theme_brand(
  brand = "block",
  variant = "light",
  base_theme = ggplot2::theme_minimal(),
  base_size = NULL
)
}
\arguments{
\item{brand}{Name of the brand to use}

\item{variant}{Theme variant ("light", "dark", or NULL for default)}

\item{base_theme}{Base ggplot2 theme to build upon (default: theme_minimal())}

\item{base_size}{Base font size (overrides brand config if specified)}
}
\value{
A ggplot2 theme object
}
\description{
Generate ggplot2 theme from brand configuration
}
\examples{
\dontrun{
library(ggplot2)
# Light theme
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  theme_brand("block", variant = "light")
  
# Dark theme
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  theme_brand("block", variant = "dark")
}
}
