% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\name{goose_save}
\alias{goose_save}
\title{Save R Object to Goose Memory}
\usage{
goose_save(
  object,
  name,
  category = "r_objects",
  tags = NULL,
  description = NULL,
  global = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{object}{The R object to save (can be any R object: data.frame, model, list, etc.)}

\item{name}{Character string. Name for the saved object (will be used as filename)}

\item{category}{Character string. Category for organizing memories (default: "r_objects")}

\item{tags}{Character vector. Optional tags for searching/filtering}

\item{description}{Character string. Optional description of the object}

\item{global}{Logical. If TRUE (default), saves to global Goose memory. If FALSE, saves to project-local memory.}

\item{overwrite}{Logical. If TRUE, overwrites existing object. If FALSE (default), errors if object exists.}
}
\value{
Invisibly returns the path where the object was saved
}
\description{
Save an R object to Goose's memory system with optional tags and category.
Objects are serialized to RDS format and metadata is stored in Goose's text format.
}
\examples{
\dontrun{
# Save a model
model <- lm(mpg ~ wt, data = mtcars)
goose_save(model, "mtcars_model", 
           category = "models",
           tags = c("regression", "mtcars"),
           description = "Linear model predicting mpg from weight")

# Save a data frame
goose_save(iris, "iris_data", 
           category = "datasets",
           tags = "example")
}
}
