% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_publish.R
\name{drive_publish}
\alias{drive_publish}
\alias{drive_unpublish}
\title{Publish native Google files}
\usage{
drive_publish(file, ..., verbose = TRUE)

drive_unpublish(file, ..., verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}.}

\item{...}{Name-value pairs to add to the API request body (see API docs
linked below for details). For \code{drive_publish()}, we include
\code{publishAuto = TRUE} and \code{publishedOutsideDomain = TRUE}, if user does not
specify other values.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
Publish (or un-publish) native Google files to the web. Native Google files
include Google Docs, Google Sheets, and Google Slides. The returned
\code{\link{dribble}} will have extra columns, \code{published} and \code{revisions_resource}.
Read more in \code{\link[=drive_reveal]{drive_reveal()}}.
}
\examples{
\dontrun{
## Upload file to publish
file <- drive_upload(
  drive_example("chicken.csv"),
  type = "spreadsheet"
  )

## Publish file
file <- drive_publish(file)
file$published

## Unpublish file
file <- drive_unpublish(file)
file$published

## Clean up
drive_rm(file)
}
}
\seealso{
Wraps the \code{revisions.update} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/revisions/update}
}
}
