% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_admin.R
\name{gce_ssh_addkeys}
\alias{gce_ssh_addkeys}
\title{Add SSH details to a gce_instance}
\usage{
gce_ssh_addkeys(instance, key.pub = NULL, key.private = NULL,
  username = Sys.info()[["user"]], overwrite = FALSE)
}
\arguments{
\item{instance}{The gce_instance}

\item{key.pub}{filepath to public SSH key}

\item{key.private}{filepath to the private SSK key}

\item{username}{SSH username to login with}

\item{overwrite}{Overwrite existing SSH details if they exist}
}
\value{
The instance with SSH details included in $ssh
}
\description{
Add SSH details to a gce_instance
}
\details{
You will only need to run this yourself if you save your SSH keys somewhere other 
  than \code{$HOME/.ssh/google_compute_engine.pub} or use a different username than 
  your local username as found in \code{Sys.info[["user"]]}, otherwise it will configure 
  itself automatically the first time you use \link{gce_ssh} in an R session.

If key.pub is NULL then will look for default Google credentials at 
  \code{file.path(Sys.getenv("HOME"), ".ssh", "google_compute_engine.pub")}
}

