% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_in_na.R
\name{sub_in_na}
\alias{sub_in_na}
\title{Regex Sub to Missing}
\usage{
sub_in_na(x, regex = "^[^A-Za-z]*$", ...)
}
\arguments{
\item{x}{A vector of text strings.}

\item{regex}{A regex to match strings in a vector.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grepl}}}
}
\value{
Returns a vector with \code{NA}s inserted.
}
\description{
Use a regex to identify elements to sub out for missing \code{NA}.  Useful
within a \pkg{magrittr} pipeline before producing the
\code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.
}
\examples{
x <- c("45", "..", "", "   ", "dog")
sub_in_na(x)
sub_in_na(x, "^\\\\s*$")

\dontrun{
library(tidyverse)
x \%>\%
    q_dtm() \%>\%
    as.matrix()

x \%>\%
    sub_in_na() \%>\%
    q_dtm() \%>\%
    as.matrix()
}
}

