% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_matrix.R
\name{clean_matrix}
\alias{clean_matrix}
\title{Clean species matrix}
\usage{
clean_matrix(matrix, env = NULL, traits = NULL)
}
\arguments{
\item{matrix}{Community data, a matrix-like object with samples in rows and species in columns. Missing values (NA) or empty character cell values will be transformed to 0.}

\item{env}{Optionally, a data frame of environmental variables, with samples in rows and variables in columns}

\item{traits}{Optionally, a data frame of species traits, with species in rows and trait variables in columns}
}
\value{
If only a species matrix is provided, the return will be a cleaned species matrix. 
If environmental and/or trait data are also provided, the result will be a list of the cleaned and subsetted matrices/data frames.
}
\description{
The function cleans a species matrix by removing species without occurrence (frequency = 0) and samples without any species (species number = 0) in one step.
 
It will also subset the corresponding observations of environmental data (samples in rows) or species trait data (species in rows), if passed to the function.
}
\examples{
# Clean species matrix
schedenveg.clean <- clean_matrix(schedenveg)

# Clean species matrix and subset environmental data
scheden.clean <- clean_matrix(schedenveg, schedenenv)
schedenveg.clean <- scheden.clean$matrix
schedenenv.clean <- scheden.clean$env

}
\author{
Friedemann von Lampe
}
