% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantile_residual_tests}
\title{Quantile residual tests}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantile_residual_tests(
  gsmvar,
  lags_ac = c(1, 3, 6, 12),
  lags_ch = lags_ac,
  nsim = 1,
  ncores = 1,
  print_res = TRUE,
  stat_tol,
  posdef_tol,
  df_tol
)
}
\arguments{
\item{x}{object of class \code{'qrtest'} generated by the function \code{quantile_residual_tests)}.}

\item{...}{currently not used.}

\item{digits}{the number of decimals to print}

\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{lags_ac}{a positive integer vector specifying the lags used to test autocorrelation.}

\item{lags_ch}{a positive integer vector specifying the lags used to test conditional heteroskedasticity.}

\item{nsim}{to how many simulations should the covariance matrix Omega used in the qr-tests be based on?
If smaller than sample size, then the covariance matrix will be evaluated from the sample. Larger number
of simulations might improve the tests size properties but it increases the computation time.}

\item{ncores}{the number of CPU cores to be used in numerical differentiation. Multiple cores
are not supported on Windows, though.}

\item{print_res}{should the test results be printed while computing the tests?}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}

\item{df_tol}{the parameter vector is considered to be outside the parameter space if all degrees of
freedom parameters are not larger than \code{2 + df_tol}.}
}
\value{
Returns an object of class \code{'qrtest'} which has its own print method. The returned object
  is a list containing the quantile residual test results for normality, autocorrelation, and conditional
  heteroskedasticity. The autocorrelation and conditional heteroskedasticity results also contain the
  associated (vectorized) individual statistics divided by their standard errors
  (see \emph{Kalliovirta and Saikkonen 2010}, s.17-20) under the label \code{$ind_stats}.
}
\description{
\code{quantile_residual_tests} performs quantile residual tests described
 by \emph{Kalliovirta and Saikkonen 2010}, testing autocorrelation, conditional heteroskedasticity,
 and normality.
}
\details{
If the function fails to calculate the tests because of numerical problems and the parameter values
  are near the border of the parameter space, it might help to use smaller numerical tolerance for the
  stationarity and positeve definiteness conditions. The numerical tolerance of an existing model
  can be changed with the function \code{update_numtols} or you can set it directly with the arguments
  \code{stat_tol} and \code{posdef_tol}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: Print method for class 'qrtest'
}}

\examples{
\donttest{
# GMVAR(3,2) model
fit32 <- fitGSMVAR(gdpdef, p=3, M=2, ncalls=1, seeds=2)
qrtests32 <- quantile_residual_tests(fit32)
qrtests32
plot(qrtests32)

# Structural GMVAR(1,2) model identified with sign
# constraints and build with hand-specified parameter values.
# Tests based on simulation procedure with nsim=1000:
params12s <- c(0.55, 0.112, 0.619, 0.173, 0.344, 0.055, -0.009, 0.718,
 0.255, 0.017, -0.136, 0.858, 0.541, 0.057, -0.162, 0.162, 3.623,
 4.726, 0.674)
W_12 <- matrix(c(1, 1, -1, 1), nrow=2)
mod12s <- GSMVAR(gdpdef, p=1, M=2, params=params12s,
                structural_pars=list(W=W_12))
qrtests12s <- quantile_residual_tests(mod12s, nsim=1000)
qrtests12s
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2021. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Virolainen S. 2021. Gaussian and Student's t mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2109.13648.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{quantile_residuals}}, \code{\link{GIRF}},
  \code{\link{diagnostic_plot}}, \code{\link{predict.gsmvar}}, \code{\link{profile_logliks}},
  \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{cond_moment_plot}}, \code{\link{update_numtols}}
}
