% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{iterate_more}
\alias{iterate_more}
\title{Maximum likelihood estimation of a GMVAR model with preliminary estimates}
\usage{
iterate_more(gmvar, maxit = 100, calc_std_errors = TRUE)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{maxit}{the maximum number of iterations in the variable metric algorithm.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an object of class \code{'gmvar'} defining the estimated GMVAR model.
}
\description{
\code{iterate_more} uses a variable metric algorithm to finalize maximum likelihood
 estimation of a GMVAR model (object of class \code{'gmvar'}) which already has preliminary estimates.
}
\details{
The purpose of \code{iterate_more} is to provide a simple and convenient tool to finalize
  the estimation when the maximum number of iterations is reached when estimating a GMVAR model
  with the main estimation function \code{fitGMVAR}. \code{iterate_more} is essentially a wrapper
  around the function \code{optim} from the package \code{stats} and \code{GMVAR} from the package
  \code{gmvarkit}.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2) model, only 5 iterations of the variable metric
# algorithm
fit12 <- fitGMVAR(data, p=1, M=2, maxit=5)
fit12

# Iterate more:
fit12_2 <- iterate_more(fit12)
fit12_2

# Structural GMVAR(1,2) model identified with sign
# constraints. Only 10 iterations of the variable metric
# algorithm
W_122 <- matrix(c(1, -1, NA, 1), nrow=2)
fit12s <- fitGMVAR(data, p=1, M=2, structural_pars=list(W=W_122),
  ncalls=10, maxit=10, seeds=1:10)
fit12s

# Iterate more:
fit12s_2 <- iterate_more(fit12s)
fit12s_2

# GMVAR(2,2) model with autoregressive parameters restricted
# to be the same for all regimes, only 10 iterations of the
# variable metric algorithm
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
fit22c <- fitGMVAR(data, p=2, M=2, constraints=C_mat, maxit=10)
fit22c

# Iterate more:
fit22c_2 <- iterate_more(fit22c)
fit22c_2

# GMVAR(3,2) model, only 10 iterations of the variable metric
# algorithm
fit32 <- fitGMVAR(data, p=3, M=2, maxit=10)
fit32

# Iterate more:
fit32_2 <- iterate_more(fit32)
fit32_2
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link[stats]{optim}}, \code{\link{profile_logliks}}
}
