% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardErrors.R
\name{print_std_errors}
\alias{print_std_errors}
\title{Print standard errors of GMVAR model in the same form as the model estimates are printed}
\usage{
print_std_errors(gmvar, digits = 3)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{digits}{how many digits should be printed?}
}
\description{
\code{print_std_errors} prints the approximate standard errors of GMVAR model in the
  same form as the parameters of objects of class \code{'gmvar'} are printed.
}
\details{
The main purpose of \code{print_std_errors} is to provide a convenient tool to match the standard
  errors to certain parameter estimates.

  Note that if linear constraints are imposed and they involve summations or multiplications, then the AR
  parameter standard errors are printed separately as they don't correspond one-to-one to the model parameter
  standard errors.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2) model with default settings
fit12 <- fitGMVAR(data, p=1, M=2)
fit12
print_std_errors(fit12)

# GMVAR(2,2) model with mean parametrization
fit22 <- fitGMVAR(data, p=2, M=2, parametrization="mean")
fit22
print_std_errors(fit22)

# GMVAR(2,2) model with autoregressive parameters restricted
# to be the same for all regimes
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
fit22c <- fitGMVAR(data, p=2, M=2, constraints=C_mat)
fit22c
print_std_errors(fit22c)

# GMVAR(2,2) model with autoregressive parameters restricted
# to be the same for all regimes and non-diagonl elements
# the coefficient matrices constrained to zero.
tmp <- matrix(c(1, rep(0, 10), 1, rep(0, 8), 1, rep(0, 10), 1),
 nrow=2*2^2, byrow=FALSE)
C_mat2 <- rbind(tmp, tmp)
fit22c2 <- fitGMVAR(data, p=2, M=2, constraints=C_mat2, ncalls=10)
fit22c2
print_std_errors(fit22c2)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{print.gmvar}},
 \code{\link{swap_parametrization}}
}
