% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messy_time.R
\name{messy_time}
\alias{messy_time}
\title{Check if the Time data frame is messy}
\usage{
messy_time(
  oTree,
  combine = FALSE,
  epoch_time = TRUE,
  participant = TRUE,
  info = FALSE
)
}
\arguments{
\item{oTree}{A list of data frames that were created
by \code{\link{import_otree}}.}

\item{combine}{Logical. \code{TRUE} if all variables referring to epoch time
should be merged and/or all variables referring to participant code should be merged
in case data of several versions of oTree are used.}

\item{epoch_time}{Logical. \code{TRUE} if all variables referring to the time
stamp should be checked and merged. Only works if \code{combine = TRUE}.}

\item{participant}{Logical. \code{TRUE} if all variables referring to the
participant code should be checked and merged.
Only works if \code{combine = TRUE}.}

\item{info}{Logical. \code{TRUE} if a brief information on the process should
be printed.}
}
\value{
This function searches for multiple variables related to the time stamp
or the participant code in the \code{$Time} data frame,
which can occur when data from both old and new oTree versions are used.

If \code{combine = FALSE}, the function will throw an error
if such variables are found.

If \code{combine = TRUE}, the function will not throw an error
if such variables are found.
Instead, it automatically combines the variables into new variables
and adds them to the original \code{$Time} data frame.
This function then returns a duplicate of the original oTree list but
with the \code{$Time} data frame modified.

The new variables are
called \code{epoch_time_completed} and \code{participant_code}.
}
\description{
Checks if the Time data frame includes both participant-related variables
and time stamp variables that appear multiple times. This may occur when
data from different oTree versions, which use different variable names,
are combined.

If desired, the function can merge these variables,
storing the data using the newer oTree version's variable names
and removing the outdated variables.
}
\examples{
\dontshow{if (rlang::is_installed("withr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set data folder first
withr::with_dir(system.file("extdata", package = "gmoTree"), {

# Import all oTree files in this folder and its subfolders
oTree <- import_otree()
})

# Show all Time column names
print(colnames(oTree$Time))

# Run function
oTree <- messy_time(oTree, combine = TRUE)

# Show all Time column names again
print(colnames(oTree$Time))
\dontshow{\}) # examplesIf}
}
\keyword{oTree}
